/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueUnmarshaller;

public class ExpectedAttributeValueUnmarshaller
implements Unmarshaller<ExpectedAttributeValue, JsonUnmarshallerContext> {
    private static final ExpectedAttributeValueUnmarshaller INSTANCE = new ExpectedAttributeValueUnmarshaller();

    public ExpectedAttributeValue unmarshall(JsonUnmarshallerContext context) throws Exception {
        ExpectedAttributeValue.Builder expectedAttributeValueBuilder = ExpectedAttributeValue.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    expectedAttributeValueBuilder.value(AttributeValueUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Exists", targetDepth)) {
                    context.nextToken();
                    expectedAttributeValueBuilder.exists((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("ComparisonOperator", targetDepth)) {
                    context.nextToken();
                    expectedAttributeValueBuilder.comparisonOperator((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AttributeValueList", targetDepth)) {
                    context.nextToken();
                    expectedAttributeValueBuilder.attributeValueList(new ListUnmarshaller((Unmarshaller)AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ExpectedAttributeValue)expectedAttributeValueBuilder.build();
    }

    public static ExpectedAttributeValueUnmarshaller getInstance() {
        return INSTANCE;
    }
}

