/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.FilterConditionMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyConditionsCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, QueryRequest> {
    private final String tableName;
    private final String indexName;
    private final String select;
    private final List<String> attributesToGet;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Map<String, Condition> keyConditions;
    private final Map<String, Condition> queryFilter;
    private final String conditionalOperator;
    private final Boolean scanIndexForward;
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final String returnConsumedCapacity;
    private final String projectionExpression;
    private final String filterExpression;
    private final String keyConditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;

    private QueryRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.select = builder.select;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.consistentRead = builder.consistentRead;
        this.keyConditions = builder.keyConditions;
        this.queryFilter = builder.queryFilter;
        this.conditionalOperator = builder.conditionalOperator;
        this.scanIndexForward = builder.scanIndexForward;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.projectionExpression = builder.projectionExpression;
        this.filterExpression = builder.filterExpression;
        this.keyConditionExpression = builder.keyConditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    public String tableName() {
        return this.tableName;
    }

    public String indexName() {
        return this.indexName;
    }

    public String select() {
        return this.select;
    }

    public List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Map<String, Condition> keyConditions() {
        return this.keyConditions;
    }

    public Map<String, Condition> queryFilter() {
        return this.queryFilter;
    }

    public String conditionalOperator() {
        return this.conditionalOperator;
    }

    public Boolean scanIndexForward() {
        return this.scanIndexForward;
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public String returnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public String projectionExpression() {
        return this.projectionExpression;
    }

    public String filterExpression() {
        return this.filterExpression;
    }

    public String keyConditionExpression() {
        return this.keyConditionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.indexName() == null ? 0 : this.indexName().hashCode());
        hashCode = 31 * hashCode + (this.select() == null ? 0 : this.select().hashCode());
        hashCode = 31 * hashCode + (this.attributesToGet() == null ? 0 : this.attributesToGet().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.consistentRead() == null ? 0 : this.consistentRead().hashCode());
        hashCode = 31 * hashCode + (this.keyConditions() == null ? 0 : this.keyConditions().hashCode());
        hashCode = 31 * hashCode + (this.queryFilter() == null ? 0 : this.queryFilter().hashCode());
        hashCode = 31 * hashCode + (this.conditionalOperator() == null ? 0 : this.conditionalOperator().hashCode());
        hashCode = 31 * hashCode + (this.scanIndexForward() == null ? 0 : this.scanIndexForward().hashCode());
        hashCode = 31 * hashCode + (this.exclusiveStartKey() == null ? 0 : this.exclusiveStartKey().hashCode());
        hashCode = 31 * hashCode + (this.returnConsumedCapacity() == null ? 0 : this.returnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.projectionExpression() == null ? 0 : this.projectionExpression().hashCode());
        hashCode = 31 * hashCode + (this.filterExpression() == null ? 0 : this.filterExpression().hashCode());
        hashCode = 31 * hashCode + (this.keyConditionExpression() == null ? 0 : this.keyConditionExpression().hashCode());
        hashCode = 31 * hashCode + (this.expressionAttributeNames() == null ? 0 : this.expressionAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.expressionAttributeValues() == null ? 0 : this.expressionAttributeValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)((Object)obj);
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.select() == null ^ this.select() == null) {
            return false;
        }
        if (other.select() != null && !other.select().equals(this.select())) {
            return false;
        }
        if (other.attributesToGet() == null ^ this.attributesToGet() == null) {
            return false;
        }
        if (other.attributesToGet() != null && !other.attributesToGet().equals(this.attributesToGet())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.consistentRead() == null ^ this.consistentRead() == null) {
            return false;
        }
        if (other.consistentRead() != null && !other.consistentRead().equals(this.consistentRead())) {
            return false;
        }
        if (other.keyConditions() == null ^ this.keyConditions() == null) {
            return false;
        }
        if (other.keyConditions() != null && !other.keyConditions().equals(this.keyConditions())) {
            return false;
        }
        if (other.queryFilter() == null ^ this.queryFilter() == null) {
            return false;
        }
        if (other.queryFilter() != null && !other.queryFilter().equals(this.queryFilter())) {
            return false;
        }
        if (other.conditionalOperator() == null ^ this.conditionalOperator() == null) {
            return false;
        }
        if (other.conditionalOperator() != null && !other.conditionalOperator().equals(this.conditionalOperator())) {
            return false;
        }
        if (other.scanIndexForward() == null ^ this.scanIndexForward() == null) {
            return false;
        }
        if (other.scanIndexForward() != null && !other.scanIndexForward().equals(this.scanIndexForward())) {
            return false;
        }
        if (other.exclusiveStartKey() == null ^ this.exclusiveStartKey() == null) {
            return false;
        }
        if (other.exclusiveStartKey() != null && !other.exclusiveStartKey().equals(this.exclusiveStartKey())) {
            return false;
        }
        if (other.returnConsumedCapacity() == null ^ this.returnConsumedCapacity() == null) {
            return false;
        }
        if (other.returnConsumedCapacity() != null && !other.returnConsumedCapacity().equals(this.returnConsumedCapacity())) {
            return false;
        }
        if (other.projectionExpression() == null ^ this.projectionExpression() == null) {
            return false;
        }
        if (other.projectionExpression() != null && !other.projectionExpression().equals(this.projectionExpression())) {
            return false;
        }
        if (other.filterExpression() == null ^ this.filterExpression() == null) {
            return false;
        }
        if (other.filterExpression() != null && !other.filterExpression().equals(this.filterExpression())) {
            return false;
        }
        if (other.keyConditionExpression() == null ^ this.keyConditionExpression() == null) {
            return false;
        }
        if (other.keyConditionExpression() != null && !other.keyConditionExpression().equals(this.keyConditionExpression())) {
            return false;
        }
        if (other.expressionAttributeNames() == null ^ this.expressionAttributeNames() == null) {
            return false;
        }
        if (other.expressionAttributeNames() != null && !other.expressionAttributeNames().equals(this.expressionAttributeNames())) {
            return false;
        }
        if (other.expressionAttributeValues() == null ^ this.expressionAttributeValues() == null) {
            return false;
        }
        return other.expressionAttributeValues() == null || other.expressionAttributeValues().equals(this.expressionAttributeValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.indexName() != null) {
            sb.append("IndexName: ").append(this.indexName()).append(",");
        }
        if (this.select() != null) {
            sb.append("Select: ").append(this.select()).append(",");
        }
        if (this.attributesToGet() != null) {
            sb.append("AttributesToGet: ").append(this.attributesToGet()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.consistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.consistentRead()).append(",");
        }
        if (this.keyConditions() != null) {
            sb.append("KeyConditions: ").append(this.keyConditions()).append(",");
        }
        if (this.queryFilter() != null) {
            sb.append("QueryFilter: ").append(this.queryFilter()).append(",");
        }
        if (this.conditionalOperator() != null) {
            sb.append("ConditionalOperator: ").append(this.conditionalOperator()).append(",");
        }
        if (this.scanIndexForward() != null) {
            sb.append("ScanIndexForward: ").append(this.scanIndexForward()).append(",");
        }
        if (this.exclusiveStartKey() != null) {
            sb.append("ExclusiveStartKey: ").append(this.exclusiveStartKey()).append(",");
        }
        if (this.returnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacity()).append(",");
        }
        if (this.projectionExpression() != null) {
            sb.append("ProjectionExpression: ").append(this.projectionExpression()).append(",");
        }
        if (this.filterExpression() != null) {
            sb.append("FilterExpression: ").append(this.filterExpression()).append(",");
        }
        if (this.keyConditionExpression() != null) {
            sb.append("KeyConditionExpression: ").append(this.keyConditionExpression()).append(",");
        }
        if (this.expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.expressionAttributeNames()).append(",");
        }
        if (this.expressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(this.expressionAttributeValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String indexName;
        private String select;
        private List<String> attributesToGet;
        private Integer limit;
        private Boolean consistentRead;
        private Map<String, Condition> keyConditions;
        private Map<String, Condition> queryFilter;
        private String conditionalOperator;
        private Boolean scanIndexForward;
        private Map<String, AttributeValue> exclusiveStartKey;
        private String returnConsumedCapacity;
        private String projectionExpression;
        private String filterExpression;
        private String keyConditionExpression;
        private Map<String, String> expressionAttributeNames;
        private Map<String, AttributeValue> expressionAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            this.setTableName(model.tableName);
            this.setIndexName(model.indexName);
            this.setSelect(model.select);
            this.setAttributesToGet(model.attributesToGet);
            this.setLimit(model.limit);
            this.setConsistentRead(model.consistentRead);
            this.setKeyConditions(model.keyConditions);
            this.setQueryFilter(model.queryFilter);
            this.setConditionalOperator(model.conditionalOperator);
            this.setScanIndexForward(model.scanIndexForward);
            this.setExclusiveStartKey(model.exclusiveStartKey);
            this.setReturnConsumedCapacity(model.returnConsumedCapacity);
            this.setProjectionExpression(model.projectionExpression);
            this.setFilterExpression(model.filterExpression);
            this.setKeyConditionExpression(model.keyConditionExpression);
            this.setExpressionAttributeNames(model.expressionAttributeNames);
            this.setExpressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getSelect() {
            return this.select;
        }

        @Override
        public final Builder select(String select) {
            this.select = select;
            return this;
        }

        @Override
        public final Builder select(Select select) {
            this.select(select.toString());
            return this;
        }

        public final void setSelect(String select) {
            this.select = select;
        }

        public final Collection<String> getAttributesToGet() {
            return this.attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final Map<String, Condition> getKeyConditions() {
            return this.keyConditions;
        }

        @Override
        public final Builder keyConditions(Map<String, Condition> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copy(keyConditions);
            return this;
        }

        public final void setKeyConditions(Map<String, Condition> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copy(keyConditions);
        }

        public final Map<String, Condition> getQueryFilter() {
            return this.queryFilter;
        }

        @Override
        public final Builder queryFilter(Map<String, Condition> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copy(queryFilter);
            return this;
        }

        public final void setQueryFilter(Map<String, Condition> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copy(queryFilter);
        }

        public final String getConditionalOperator() {
            return this.conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final Boolean getScanIndexForward() {
            return this.scanIndexForward;
        }

        @Override
        public final Builder scanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
            return this;
        }

        public final void setScanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
        }

        public final Map<String, AttributeValue> getExclusiveStartKey() {
            return this.exclusiveStartKey;
        }

        @Override
        public final Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
            return this;
        }

        public final void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final String getKeyConditionExpression() {
            return this.keyConditionExpression;
        }

        @Override
        public final Builder keyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
            return this;
        }

        public final void setKeyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue> getExpressionAttributeValues() {
            return this.expressionAttributeValues;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
        }

        public QueryRequest build() {
            return new QueryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueryRequest> {
        public Builder tableName(String var1);

        public Builder indexName(String var1);

        public Builder select(String var1);

        public Builder select(Select var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder limit(Integer var1);

        public Builder consistentRead(Boolean var1);

        public Builder keyConditions(Map<String, Condition> var1);

        public Builder queryFilter(Map<String, Condition> var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder scanIndexForward(Boolean var1);

        public Builder exclusiveStartKey(Map<String, AttributeValue> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder projectionExpression(String var1);

        public Builder filterExpression(String var1);

        public Builder keyConditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);
    }
}

