/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteItemResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DeleteItemResponse> {
    private final Map<String, AttributeValue> attributes;
    private final ConsumedCapacity consumedCapacity;
    private final ItemCollectionMetrics itemCollectionMetrics;

    private DeleteItemResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.consumedCapacity = builder.consumedCapacity;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
    }

    public Map<String, AttributeValue> attributes() {
        return this.attributes;
    }

    public ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public ItemCollectionMetrics itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.consumedCapacity() == null ? 0 : this.consumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.itemCollectionMetrics() == null ? 0 : this.itemCollectionMetrics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteItemResponse)) {
            return false;
        }
        DeleteItemResponse other = (DeleteItemResponse)((Object)obj);
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.consumedCapacity() == null ^ this.consumedCapacity() == null) {
            return false;
        }
        if (other.consumedCapacity() != null && !other.consumedCapacity().equals(this.consumedCapacity())) {
            return false;
        }
        if (other.itemCollectionMetrics() == null ^ this.itemCollectionMetrics() == null) {
            return false;
        }
        return other.itemCollectionMetrics() == null || other.itemCollectionMetrics().equals(this.itemCollectionMetrics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(this.consumedCapacity()).append(",");
        }
        if (this.itemCollectionMetrics() != null) {
            sb.append("ItemCollectionMetrics: ").append(this.itemCollectionMetrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> attributes;
        private ConsumedCapacity consumedCapacity;
        private ItemCollectionMetrics itemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteItemResponse model) {
            this.setAttributes(model.attributes);
            this.setConsumedCapacity(model.consumedCapacity);
            this.setItemCollectionMetrics(model.itemCollectionMetrics);
        }

        public final Map<String, AttributeValue> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, AttributeValue> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, AttributeValue> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
        }

        public final ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
        }

        public final ItemCollectionMetrics getItemCollectionMetrics() {
            return this.itemCollectionMetrics;
        }

        @Override
        public final Builder itemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics;
            return this;
        }

        public final void setItemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics;
        }

        public DeleteItemResponse build() {
            return new DeleteItemResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteItemResponse> {
        public Builder attributes(Map<String, AttributeValue> var1);

        public Builder consumedCapacity(ConsumedCapacity var1);

        public Builder itemCollectionMetrics(ItemCollectionMetrics var1);
    }
}

