/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.Map;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.GetItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.api.GetItemApi;
import software.amazon.awssdk.services.dynamodb.document.internal.AbstractImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.spec.GetItemSpec;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;

public class GetItemImpl
extends AbstractImpl
implements GetItemApi {
    public GetItemImpl(DynamoDBClient client, Table table) {
        super(client, table);
    }

    @Override
    public GetItemOutcome getItemOutcome(KeyAttribute ... primaryKeyComponents) {
        return this.doLoadItem(new GetItemSpec().withPrimaryKey(primaryKeyComponents));
    }

    @Override
    public GetItemOutcome getItemOutcome(PrimaryKey primaryKey) {
        return this.doLoadItem(new GetItemSpec().withPrimaryKey(primaryKey));
    }

    @Override
    public GetItemOutcome getItemOutcome(PrimaryKey primaryKey, String projectionExpression, Map<String, String> nameMap) {
        return this.doLoadItem(new GetItemSpec().withPrimaryKey(primaryKey).withProjectionExpression(projectionExpression).withNameMap(nameMap));
    }

    @Override
    public GetItemOutcome getItemOutcome(GetItemSpec spec) {
        return this.doLoadItem(spec);
    }

    @Override
    public Item getItem(GetItemSpec spec) {
        return this.doLoadItem(spec).getItem();
    }

    private GetItemOutcome doLoadItem(GetItemSpec spec) {
        String tableName = this.getTable().getTableName();
        GetItemRequest req = (GetItemRequest)((Object)((GetItemRequest)spec.getRequest()).toBuilder().tableName(tableName).key(InternalUtils.toAttributeValueMap(spec.getKeyComponents())).expressionAttributeNames(spec.nameMap()).build());
        GetItemResponse result = this.getClient().getItem(req);
        return new GetItemOutcome(result);
    }

    @Override
    public Item getItem(KeyAttribute ... primaryKey) {
        return this.getItemOutcome(primaryKey).getItem();
    }

    @Override
    public Item getItem(PrimaryKey primaryKey) {
        return this.getItemOutcome(primaryKey).getItem();
    }

    @Override
    public Item getItem(PrimaryKey primaryKey, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(primaryKey, projectionExpression, nameMap).getItem();
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue) {
        return this.getItemOutcome(new KeyAttribute(hashKeyName, hashKeyValue));
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.getItemOutcome(new KeyAttribute(hashKeyName, hashKeyValue), new KeyAttribute(rangeKeyName, rangeKeyValue));
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue) {
        return this.getItemOutcome(hashKeyName, hashKeyValue).getItem();
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.getItemOutcome(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue).getItem();
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(new PrimaryKey(hashKeyName, hashKeyValue), projectionExpression, nameMap);
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), projectionExpression, nameMap);
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(new PrimaryKey(hashKeyName, hashKeyValue), projectionExpression, nameMap).getItem();
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemOutcome(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), projectionExpression, nameMap).getItem();
    }
}

