/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateTimeToLiveRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateTimeToLiveRequest> {
    private final String tableName;
    private final TimeToLiveSpecification timeToLiveSpecification;

    private UpdateTimeToLiveRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.timeToLiveSpecification = builder.timeToLiveSpecification;
    }

    public String tableName() {
        return this.tableName;
    }

    public TimeToLiveSpecification timeToLiveSpecification() {
        return this.timeToLiveSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.timeToLiveSpecification() == null ? 0 : this.timeToLiveSpecification().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTimeToLiveRequest)) {
            return false;
        }
        UpdateTimeToLiveRequest other = (UpdateTimeToLiveRequest)((Object)obj);
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.timeToLiveSpecification() == null ^ this.timeToLiveSpecification() == null) {
            return false;
        }
        return other.timeToLiveSpecification() == null || other.timeToLiveSpecification().equals(this.timeToLiveSpecification());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.timeToLiveSpecification() != null) {
            sb.append("TimeToLiveSpecification: ").append(this.timeToLiveSpecification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String tableName;
        private TimeToLiveSpecification timeToLiveSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTimeToLiveRequest model) {
            this.setTableName(model.tableName);
            this.setTimeToLiveSpecification(model.timeToLiveSpecification);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final TimeToLiveSpecification getTimeToLiveSpecification() {
            return this.timeToLiveSpecification;
        }

        @Override
        public final Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        public final void setTimeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
        }

        public UpdateTimeToLiveRequest build() {
            return new UpdateTimeToLiveRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateTimeToLiveRequest> {
        public Builder tableName(String var1);

        public Builder timeToLiveSpecification(TimeToLiveSpecification var1);
    }
}

