/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.ItemCollection;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.QueryFilter;
import software.amazon.awssdk.services.dynamodb.document.QueryOutcome;
import software.amazon.awssdk.services.dynamodb.document.RangeKeyCondition;
import software.amazon.awssdk.services.dynamodb.document.ScanFilter;
import software.amazon.awssdk.services.dynamodb.document.ScanOutcome;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.api.QueryApi;
import software.amazon.awssdk.services.dynamodb.document.api.ScanApi;
import software.amazon.awssdk.services.dynamodb.document.internal.IndexQueryImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.IndexScanImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.ScanImpl;
import software.amazon.awssdk.services.dynamodb.document.spec.QuerySpec;
import software.amazon.awssdk.services.dynamodb.document.spec.ScanSpec;
import software.amazon.awssdk.services.dynamodb.document.spec.UpdateTableSpec;
import software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction;

@ThreadSafe
public class Index
implements QueryApi,
ScanApi {
    private static final long SLEEP_TIME_MILLIS = 5000L;
    private final Table table;
    private final String indexName;
    private final QueryApi queryDelegate;
    private final ScanImpl scanDelegate;

    Index(DynamoDBClient client, String indexName, Table table) {
        if (client == null) {
            throw new IllegalArgumentException("client must be specified");
        }
        if (indexName == null || indexName.trim().length() == 0) {
            throw new IllegalArgumentException("index name must not be null or empty");
        }
        if (table == null) {
            throw new IllegalArgumentException("table must be specified");
        }
        this.table = table;
        this.indexName = indexName;
        this.queryDelegate = new IndexQueryImpl(client, this);
        this.scanDelegate = new IndexScanImpl(client, this);
    }

    public final Table getTable() {
        return this.table;
    }

    public final String getIndexName() {
        return this.indexName;
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String projectionExpression, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, projectionExpression, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(QuerySpec spec) {
        return this.queryDelegate.query(spec);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey) {
        return this.queryDelegate.query(hashKey);
    }

    public TableDescription updateGsi(ProvisionedThroughput provisionedThroughput) {
        return this.table.updateTable(new UpdateTableSpec().withGlobalSecondaryIndexUpdates((GlobalSecondaryIndexUpdate)GlobalSecondaryIndexUpdate.builder().update((UpdateGlobalSecondaryIndexAction)UpdateGlobalSecondaryIndexAction.builder().indexName(this.indexName).provisionedThroughput(provisionedThroughput).build()).build()));
    }

    public TableDescription deleteGsi() {
        return this.table.updateTable(new UpdateTableSpec().withGlobalSecondaryIndexUpdates((GlobalSecondaryIndexUpdate)GlobalSecondaryIndexUpdate.builder().delete((DeleteGlobalSecondaryIndexAction)DeleteGlobalSecondaryIndexAction.builder().indexName(this.indexName).build()).build()));
    }

    public TableDescription waitForActive() throws InterruptedException {
        TableDescription desc;
        List<GlobalSecondaryIndexDescription> list;
        Table table = this.getTable();
        String tableName = table.getTableName();
        String indexName = this.getIndexName();
        block4: while ((list = (desc = table.waitForActive()).globalSecondaryIndexes()) != null) {
            for (GlobalSecondaryIndexDescription d : list) {
                if (!d.indexName().equals(indexName)) continue;
                String status = d.indexStatus();
                switch (IndexStatus.fromValue(status)) {
                    case ACTIVE: {
                        return desc;
                    }
                    case CREATING: 
                    case UPDATING: {
                        Thread.sleep(5000L);
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Global Secondary Index " + indexName + " is not being created or updated (with status=" + status + ")");
            }
        }
        throw new IllegalArgumentException("Global Secondary Index " + indexName + " does not exist in Table " + tableName + ")");
    }

    public TableDescription waitForDelete() throws InterruptedException {
        TableDescription desc;
        List<GlobalSecondaryIndexDescription> list;
        String indexName = this.getIndexName();
        block0: while ((list = (desc = this.getTable().waitForActive()).globalSecondaryIndexes()) != null) {
            for (GlobalSecondaryIndexDescription d : list) {
                if (!d.indexName().equals(indexName)) continue;
                String status = d.indexStatus();
                if (IndexStatus.fromValue(status) == IndexStatus.DELETING) {
                    Thread.sleep(5000L);
                    continue block0;
                }
                throw new IllegalArgumentException("Global Secondary Index " + indexName + " is not being deleted (with status=" + status + ")");
            }
        }
        return desc;
    }

    public TableDescription waitForActiveOrDelete() throws InterruptedException {
        TableDescription desc;
        List<GlobalSecondaryIndexDescription> list;
        Table table = this.getTable();
        String indexName = this.getIndexName();
        block0: while ((list = (desc = table.waitForActive()).globalSecondaryIndexes()) != null) {
            for (GlobalSecondaryIndexDescription d : desc.globalSecondaryIndexes()) {
                if (!d.indexName().equals(indexName)) continue;
                String status = d.indexStatus();
                if (IndexStatus.fromValue(status) == IndexStatus.ACTIVE) {
                    return desc;
                }
                Thread.sleep(5000L);
                continue block0;
            }
        }
        return desc;
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanFilter ... scanFilters) {
        return this.scanDelegate.scan(scanFilters);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.scanDelegate.scan(filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.scanDelegate.scan(filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanSpec params) {
        return this.scanDelegate.scan(params);
    }
}

