/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;

@SdkInternalApi
public class ProvisionedThroughputDescriptionMarshaller {
    private static final MarshallingInfo<Instant> LASTINCREASEDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastIncreaseDateTime").build();
    private static final MarshallingInfo<Instant> LASTDECREASEDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastDecreaseDateTime").build();
    private static final MarshallingInfo<Long> NUMBEROFDECREASESTODAY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfDecreasesToday").build();
    private static final MarshallingInfo<Long> READCAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadCapacityUnits").build();
    private static final MarshallingInfo<Long> WRITECAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WriteCapacityUnits").build();
    private static final ProvisionedThroughputDescriptionMarshaller instance = new ProvisionedThroughputDescriptionMarshaller();

    public static ProvisionedThroughputDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProvisionedThroughputDescription provisionedThroughputDescription, ProtocolMarshaller protocolMarshaller) {
        if (provisionedThroughputDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.lastIncreaseDateTime(), LASTINCREASEDATETIME_BINDING);
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.lastDecreaseDateTime(), LASTDECREASEDATETIME_BINDING);
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.numberOfDecreasesToday(), NUMBEROFDECREASESTODAY_BINDING);
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.readCapacityUnits(), READCAPACITYUNITS_BINDING);
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.writeCapacityUnits(), WRITECAPACITYUNITS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

