/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.transform.StreamSpecificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamSpecification> {
    private final Boolean streamEnabled;
    private final String streamViewType;

    private StreamSpecification(BuilderImpl builder) {
        this.streamEnabled = builder.streamEnabled;
        this.streamViewType = builder.streamViewType;
    }

    public Boolean streamEnabled() {
        return this.streamEnabled;
    }

    public String streamViewType() {
        return this.streamViewType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamEnabled() == null ? 0 : this.streamEnabled().hashCode());
        hashCode = 31 * hashCode + (this.streamViewType() == null ? 0 : this.streamViewType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSpecification)) {
            return false;
        }
        StreamSpecification other = (StreamSpecification)obj;
        if (other.streamEnabled() == null ^ this.streamEnabled() == null) {
            return false;
        }
        if (other.streamEnabled() != null && !other.streamEnabled().equals(this.streamEnabled())) {
            return false;
        }
        if (other.streamViewType() == null ^ this.streamViewType() == null) {
            return false;
        }
        return other.streamViewType() == null || other.streamViewType().equals(this.streamViewType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamEnabled() != null) {
            sb.append("StreamEnabled: ").append(this.streamEnabled()).append(",");
        }
        if (this.streamViewType() != null) {
            sb.append("StreamViewType: ").append(this.streamViewType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean streamEnabled;
        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSpecification model) {
            this.setStreamEnabled(model.streamEnabled);
            this.setStreamViewType(model.streamViewType);
        }

        public final Boolean getStreamEnabled() {
            return this.streamEnabled;
        }

        @Override
        public final Builder streamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
            return this;
        }

        public final void setStreamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
        }

        public final String getStreamViewType() {
            return this.streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public final void setStreamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
        }

        public StreamSpecification build() {
            return new StreamSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamSpecification> {
        public Builder streamEnabled(Boolean var1);

        public Builder streamViewType(String var1);

        public Builder streamViewType(StreamViewType var1);
    }
}

