/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document;

import software.amazon.awssdk.services.dynamodb.document.KeyConditions;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;

public class RangeKeyCondition {
    private final String attrName;
    private KeyConditions kcond;
    private Object[] values;

    public RangeKeyCondition(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        this.attrName = attrName;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public KeyConditions getKeyCondition() {
        return this.kcond;
    }

    public Object[] values() {
        return this.values == null ? null : (Object[])this.values.clone();
    }

    public RangeKeyCondition eq(Object val) {
        this.kcond = KeyConditions.EQ;
        return this.values(val);
    }

    public RangeKeyCondition beginsWith(String val) {
        this.kcond = KeyConditions.BEGINS_WITH;
        return this.values(val);
    }

    public RangeKeyCondition between(Object low, Object hi) {
        this.kcond = KeyConditions.BETWEEN;
        return this.values(low, hi);
    }

    public RangeKeyCondition ge(Object val) {
        this.kcond = KeyConditions.GE;
        return this.values(val);
    }

    public RangeKeyCondition gt(Object val) {
        this.kcond = KeyConditions.GT;
        return this.values(val);
    }

    public RangeKeyCondition le(Object val) {
        this.kcond = KeyConditions.LE;
        return this.values(val);
    }

    public RangeKeyCondition lt(Object val) {
        this.kcond = KeyConditions.LT;
        return this.values(val);
    }

    private RangeKeyCondition values(Object ... values) {
        this.values = values;
        return this;
    }
}

