/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import software.amazon.awssdk.services.dynamodb.datamodeling.S3ClientCache;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3Link;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.SUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class S3LinkUnmarshaller
extends SUnmarshaller {
    private static final S3LinkUnmarshaller INSTANCE = new S3LinkUnmarshaller();
    private final S3ClientCache clientCache;

    private S3LinkUnmarshaller() {
        this(null);
    }

    public S3LinkUnmarshaller(S3ClientCache clientCache) {
        this.clientCache = clientCache;
    }

    public static S3LinkUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        if (this.clientCache == null) {
            throw new IllegalStateException("Mapper must be constructed with S3 AWS Credentials to load S3Link");
        }
        return S3Link.fromJson(this.clientCache, value.s());
    }
}

