/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class BooleanSetUnmarshaller
implements ArgumentUnmarshaller {
    private static final BooleanSetUnmarshaller INSTANCE = new BooleanSetUnmarshaller();

    private BooleanSetUnmarshaller() {
    }

    public static BooleanSetUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public void typeCheck(AttributeValue value, Method setter) {
        if (value.ns() == null && value.l() == null) {
            throw new DynamoDbMappingException("Expected either L or NS in value " + value + " when invoking " + setter);
        }
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        if (value.l() != null) {
            return this.unmarshallList(value.l());
        }
        return this.unmarshallNs(value.ns());
    }

    private Set<Boolean> unmarshallList(List<AttributeValue> values) {
        HashSet<Boolean> result = new HashSet<Boolean>();
        for (AttributeValue value : values) {
            Boolean bool;
            if (Boolean.TRUE.equals(value.nul())) {
                bool = null;
            } else {
                bool = value.bool();
                if (bool == null) {
                    throw new DynamoDbMappingException(value + " is not a boolean");
                }
            }
            if (result.add(bool)) continue;
            throw new DynamoDbMappingException("Duplicate value (" + bool + ") found in " + values);
        }
        return result;
    }

    private Set<Boolean> unmarshallNs(List<String> values) {
        HashSet<Boolean> result = new HashSet<Boolean>();
        for (String s : values) {
            if ("1".equals(s)) {
                result.add(Boolean.TRUE);
                continue;
            }
            if ("0".equals(s)) {
                result.add(Boolean.FALSE);
                continue;
            }
            throw new IllegalArgumentException("Expected '1' or '0' for boolean value, was " + s);
        }
        return result;
    }
}

