/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.LinkedList;
import java.util.List;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapper;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedList;
import software.amazon.awssdk.services.dynamodb.datamodeling.ParallelScanTask;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class PaginatedParallelScanList<T>
extends PaginatedList<T> {
    private final ParallelScanTask parallelScanTask;
    private final DynamoDbMapperConfig config;

    public PaginatedParallelScanList(DynamoDbMapper mapper, Class<T> clazz, DynamoDBClient dynamo, ParallelScanTask parallelScanTask, DynamoDbMapperConfig.PaginationLoadingStrategy paginationLoadingStrategy, DynamoDbMapperConfig config) {
        super(mapper, clazz, dynamo, paginationLoadingStrategy);
        this.parallelScanTask = parallelScanTask;
        this.config = config;
        this.allResults.addAll(this.marshalParallelScanResponsesIntoObjects(parallelScanTask.nextBatchOfScanResponses()));
        if (paginationLoadingStrategy == DynamoDbMapperConfig.PaginationLoadingStrategy.EAGER_LOADING) {
            this.loadAllResults();
        }
    }

    @Override
    protected boolean atEndOfResults() {
        return this.parallelScanTask.isAllSegmentScanFinished();
    }

    @Override
    protected List<T> fetchNextPage() {
        return this.marshalParallelScanResponsesIntoObjects(this.parallelScanTask.nextBatchOfScanResponses());
    }

    private List<T> marshalParallelScanResponsesIntoObjects(List<ScanResponse> scanResults) {
        LinkedList allItems = new LinkedList();
        for (ScanResponse scanResult : scanResults) {
            if (null == scanResult) continue;
            allItems.addAll(this.mapper.marshallIntoObjects(this.mapper.toParameters(scanResult.items(), this.clazz, this.parallelScanTask.getTableName(), this.config)));
        }
        return allItems;
    }
}

