/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import software.amazon.awssdk.annotation.SdkInternalApi;

public interface DynamoDbTypeConverter<S, T> {
    public S convert(T var1);

    public T unconvert(S var1);

    public static class NullSafeConverter<S, T>
    extends DelegateConverter<S, T> {
        public NullSafeConverter(DynamoDbTypeConverter<S, T> delegate) {
            super(delegate);
        }

        @Override
        public S convert(T object) {
            return object == null ? null : (S)super.convert(object);
        }

        @Override
        public T unconvert(S object) {
            return object == null ? null : (T)super.unconvert(object);
        }
    }

    public static class DelegateConverter<S, T>
    extends AbstractConverter<S, T> {
        private final DynamoDbTypeConverter<S, T> delegate;

        public DelegateConverter(DynamoDbTypeConverter<S, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public S convert(T object) {
            return this.delegate.convert(object);
        }

        @Override
        public T unconvert(S object) {
            return this.delegate.unconvert(object);
        }
    }

    public static class ExtendedConverter<S, U, T>
    extends AbstractConverter<S, T> {
        private final DynamoDbTypeConverter<S, U> source;
        private final DynamoDbTypeConverter<U, T> target;

        public ExtendedConverter(DynamoDbTypeConverter<S, U> source, DynamoDbTypeConverter<U, T> target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public S convert(T o) {
            U o1 = this.target.convert(o);
            S o2 = this.source.convert(o1);
            return o2;
        }

        @Override
        public T unconvert(S o) {
            return this.target.unconvert(this.source.unconvert(o));
        }
    }

    @SdkInternalApi
    public static abstract class AbstractConverter<S, T>
    implements DynamoDbTypeConverter<S, T> {
        public static <S, U, T> ExtendedConverter<S, U, T> join(DynamoDbTypeConverter<S, U> source, DynamoDbTypeConverter<U, T> target) {
            return new ExtendedConverter<S, U, T>(source, target);
        }

        public static <S, T> NullSafeConverter<S, T> nullSafe(DynamoDbTypeConverter<S, T> converter) {
            return new NullSafeConverter<S, T>(converter);
        }

        public <U> DynamoDbTypeConverter<S, U> joinAll(DynamoDbTypeConverter<T, U> ... targets) {
            AbstractConverter converter = this.nullSafe();
            for (DynamoDbTypeConverter<U, U> dynamoDbTypeConverter : targets) {
                if (dynamoDbTypeConverter == null) continue;
                converter = converter.join(AbstractConverter.nullSafe(dynamoDbTypeConverter));
            }
            return converter;
        }

        public <U> ExtendedConverter<S, T, U> join(DynamoDbTypeConverter<T, U> target) {
            return AbstractConverter.join(this, target);
        }

        public NullSafeConverter<S, T> nullSafe() {
            return AbstractConverter.nullSafe(this);
        }
    }
}

