/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbDeleteExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapper;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperTableModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbQueryExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbSaveExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbScanExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedParallelScanList;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedQueryList;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedScanList;
import software.amazon.awssdk.services.dynamodb.datamodeling.QueryResultPage;
import software.amazon.awssdk.services.dynamodb.datamodeling.ScanResultPage;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;

public final class DynamoDbTableMapper<T, H, R> {
    private static final Logger log = LoggerFactory.getLogger(DynamoDbTableMapper.class);
    private final DynamoDbMapperTableModel<T> model;
    private final DynamoDbMapperFieldModel<T, H> hk;
    private final DynamoDbMapperFieldModel<T, R> rk;
    private final DynamoDbMapperConfig config;
    private final DynamoDbMapper mapper;
    private final DynamoDBClient db;

    protected DynamoDbTableMapper(DynamoDBClient db, DynamoDbMapper mapper, DynamoDbMapperConfig config, DynamoDbMapperTableModel<T> model) {
        this.rk = model.rangeKeyIfExists();
        this.hk = model.hashKey();
        this.model = model;
        this.config = config;
        this.mapper = mapper;
        this.db = db;
    }

    public <V> DynamoDbMapperFieldModel<T, V> field(String attributeName) {
        return this.model.field(attributeName);
    }

    public DynamoDbMapperFieldModel<T, H> hashKey() {
        return this.model.hashKey();
    }

    public DynamoDbMapperFieldModel<T, R> rangeKey() {
        return this.model.rangeKey();
    }

    public List<T> batchLoad(Iterable<T> itemsToGet) {
        Map<String, List<Object>> results = this.mapper.batchLoad(itemsToGet);
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        return results.get(this.mapper.getTableName(this.model.targetType(), this.config));
    }

    public List<DynamoDbMapper.FailedBatch> batchSave(Iterable<T> objectsToSave) {
        return this.mapper.batchWrite(objectsToSave, Collections.emptyList());
    }

    public List<DynamoDbMapper.FailedBatch> batchDelete(Iterable<T> objectsToDelete) {
        return this.mapper.batchWrite(Collections.emptyList(), objectsToDelete);
    }

    public List<DynamoDbMapper.FailedBatch> batchWrite(Iterable<T> objectsToWrite, Iterable<T> objectsToDelete) {
        return this.mapper.batchWrite(objectsToWrite, objectsToDelete);
    }

    public T load(H hashKey) {
        return this.mapper.load(this.model.targetType(), hashKey);
    }

    public T load(H hashKey, R rangeKey) {
        return this.mapper.load(this.model.targetType(), hashKey, rangeKey);
    }

    public void save(T object) {
        this.mapper.save(object);
    }

    public void save(T object, DynamoDbSaveExpression saveExpression) {
        this.mapper.save(object, saveExpression);
    }

    public void saveIfNotExists(T object) throws ConditionalCheckFailedException {
        DynamoDbSaveExpression saveExpression = new DynamoDbSaveExpression();
        for (DynamoDbMapperFieldModel<T, Object> key : this.model.keys()) {
            saveExpression.withExpectedEntry(key.name(), (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(false).build());
        }
        this.mapper.save(object, saveExpression);
    }

    public void saveIfExists(T object) throws ConditionalCheckFailedException {
        DynamoDbSaveExpression saveExpression = new DynamoDbSaveExpression();
        for (DynamoDbMapperFieldModel<T, Object> key : this.model.keys()) {
            saveExpression.withExpectedEntry(key.name(), (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(true).value((AttributeValue)key.convert(key.get(object))).build());
        }
        this.mapper.save(object, saveExpression);
    }

    public void delete(T object) {
        this.mapper.delete(object);
    }

    public void delete(T object, DynamoDbDeleteExpression deleteExpression) {
        this.mapper.delete(object, deleteExpression);
    }

    public void deleteIfExists(T object) throws ConditionalCheckFailedException {
        DynamoDbDeleteExpression deleteExpression = new DynamoDbDeleteExpression();
        for (DynamoDbMapperFieldModel<T, Object> key : this.model.keys()) {
            deleteExpression.withExpectedEntry(key.name(), (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(true).value((AttributeValue)key.convert(key.get(object))).build());
        }
        this.mapper.delete(object, deleteExpression);
    }

    public int count(DynamoDbQueryExpression<T> queryExpression) {
        return this.mapper.count(this.model.targetType(), queryExpression);
    }

    public PaginatedQueryList<T> query(DynamoDbQueryExpression<T> queryExpression) {
        return this.mapper.query(this.model.targetType(), queryExpression);
    }

    public QueryResultPage<T> queryPage(DynamoDbQueryExpression<T> queryExpression) {
        return this.mapper.queryPage(this.model.targetType(), queryExpression);
    }

    public int count(DynamoDbScanExpression scanExpression) {
        return this.mapper.count(this.model.targetType(), scanExpression);
    }

    public PaginatedScanList<T> scan(DynamoDbScanExpression scanExpression) {
        return this.mapper.scan(this.model.targetType(), scanExpression);
    }

    public ScanResultPage<T> scanPage(DynamoDbScanExpression scanExpression) {
        return this.mapper.scanPage(this.model.targetType(), scanExpression);
    }

    public PaginatedParallelScanList<T> parallelScan(DynamoDbScanExpression scanExpression, int totalSegments) {
        return this.mapper.parallelScan(this.model.targetType(), scanExpression, totalSegments);
    }

    public TableDescription describeTable() {
        return this.db.describeTable((DescribeTableRequest)((Object)DescribeTableRequest.builder().tableName(this.mapper.getTableName(this.model.targetType(), this.config)).build())).table();
    }

    public TableDescription createTable(ProvisionedThroughput throughput) {
        CreateTableRequest request = this.mapper.generateCreateTableRequest(this.model.targetType());
        CreateTableRequest.Builder modified = request.toBuilder().provisionedThroughput(throughput);
        if (request.globalSecondaryIndexes() != null) {
            modified.globalSecondaryIndexes((Collection<GlobalSecondaryIndex>)null);
            for (GlobalSecondaryIndex gsi : request.globalSecondaryIndexes()) {
                gsi = (GlobalSecondaryIndex)gsi.toBuilder().provisionedThroughput(throughput).build();
                modified.globalSecondaryIndexes(gsi);
            }
            request = (CreateTableRequest)((Object)modified.build());
        }
        request = (CreateTableRequest)((Object)modified.build());
        return this.db.createTable(request).tableDescription();
    }

    public boolean createTableIfNotExists(ProvisionedThroughput throughput) {
        try {
            this.createTable(throughput);
        }
        catch (ResourceInUseException e) {
            if (log.isTraceEnabled()) {
                log.trace("Table already exists, no need to create", (Throwable)((Object)e));
            }
            return false;
        }
        return true;
    }

    public TableDescription deleteTable() {
        return this.db.deleteTable(this.mapper.generateDeleteTableRequest(this.model.targetType())).tableDescription();
    }

    public boolean deleteTableIfExists() {
        try {
            this.deleteTable();
        }
        catch (ResourceNotFoundException e) {
            if (log.isTraceEnabled()) {
                log.trace("Table does not exist, no need to delete", (Throwable)((Object)e));
            }
            return false;
        }
        return true;
    }
}

