/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerateStrategy;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerator;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.KeyType;

public class DynamoDbMapperFieldModel<T, V>
implements DynamoDbAutoGenerator<V>,
DynamoDbTypeConverter<AttributeValue, V> {
    private final Properties<V> properties;
    private final DynamoDbTypeConverter<AttributeValue, V> converter;
    private final DynamoDbAttributeType attributeType;
    private final Reflect<T, V> reflect;

    private DynamoDbMapperFieldModel(Builder<T, V> builder) {
        this.properties = ((Builder)builder).properties;
        this.converter = ((Builder)builder).converter;
        this.attributeType = ((Builder)builder).attributeType;
        this.reflect = ((Builder)builder).reflect;
    }

    @Deprecated
    public String getDynamoDbAttributeName() {
        return this.properties.attributeName();
    }

    @Deprecated
    public DynamoDbAttributeType getDynamoDbAttributeType() {
        return this.attributeType;
    }

    public final String name() {
        return this.properties.attributeName();
    }

    public final V get(T object) {
        return this.reflect.get(object);
    }

    public final void set(T object, V value) {
        this.reflect.set(object, value);
    }

    @Override
    public final DynamoDbAutoGenerateStrategy getGenerateStrategy() {
        if (this.properties.autoGenerator() != null) {
            return this.properties.autoGenerator().getGenerateStrategy();
        }
        return null;
    }

    @Override
    public final V generate(V currentValue) {
        return this.properties.autoGenerator().generate(currentValue);
    }

    @Override
    public final AttributeValue convert(V object) {
        AttributeValue v = this.converter.convert(object);
        return v;
    }

    @Override
    public final V unconvert(AttributeValue object) {
        return this.converter.unconvert(object);
    }

    public final AttributeValue getAndConvert(T object) {
        return this.convert((Object)this.get(object));
    }

    public final void unconvertAndSet(T object, AttributeValue value) {
        this.set(object, this.unconvert(value));
    }

    public final DynamoDbAttributeType attributeType() {
        return this.attributeType;
    }

    public final KeyType keyType() {
        return this.properties.keyType();
    }

    public final boolean versioned() {
        return this.properties.versioned();
    }

    public final List<String> globalSecondaryIndexNames(KeyType keyType) {
        if (this.properties.globalSecondaryIndexNames().containsKey((Object)keyType)) {
            return this.properties.globalSecondaryIndexNames().get((Object)keyType);
        }
        return Collections.emptyList();
    }

    public final List<String> localSecondaryIndexNames() {
        return this.properties.localSecondaryIndexNames();
    }

    public final boolean indexed() {
        return !this.properties.globalSecondaryIndexNames().isEmpty() || !this.properties.localSecondaryIndexNames().isEmpty();
    }

    public final Condition beginsWith(V value) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.BEGINS_WITH).attributeValueList(new AttributeValue[]{this.convert((Object)value)}).build();
    }

    public final Condition between(V lo, V hi) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.BETWEEN).attributeValueList(new AttributeValue[]{this.convert((Object)lo), this.convert((Object)hi)}).build();
    }

    public final Condition contains(V value) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.CONTAINS).attributeValueList(new AttributeValue[]{this.convert((Object)value)}).build();
    }

    public final Condition eq(V value) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(new AttributeValue[]{this.convert((Object)value)}).build();
    }

    public final Condition ge(V value) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.GE).attributeValueList(new AttributeValue[]{this.convert((Object)value)}).build();
    }

    public final Condition gt(V value) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.GT).attributeValueList(new AttributeValue[]{this.convert((Object)value)}).build();
    }

    public final Condition in(Collection<V> values) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.IN).attributeValueList(StandardTypeConverters.Vector.LIST.convert(values, this)).build();
    }

    public final Condition in(V ... values) {
        return this.in((Collection<V>)Arrays.asList(values));
    }

    public final Condition isNull() {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.NULL).build();
    }

    public final Condition le(V value) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.LE).attributeValueList(new AttributeValue[]{this.convert((Object)value)}).build();
    }

    public final Condition lt(V value) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.LT).attributeValueList(new AttributeValue[]{this.convert((Object)value)}).build();
    }

    public final Condition ne(V value) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.NE).attributeValueList(new AttributeValue[]{this.convert((Object)value)}).build();
    }

    public final Condition notContains(V value) {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.NOT_CONTAINS).attributeValueList(new AttributeValue[]{this.convert((Object)value)}).build();
    }

    public final Condition notNull() {
        return (Condition)Condition.builder().comparisonOperator(ComparisonOperator.NOT_NULL).build();
    }

    public final Condition betweenAny(V lo, V hi) {
        return lo == null ? (hi == null ? null : this.le(hi)) : (hi == null ? this.ge(lo) : (lo.equals(hi) ? this.eq(lo) : this.between(lo, hi)));
    }

    static class Builder<T, V> {
        private final Properties<V> properties;
        private DynamoDbTypeConverter<AttributeValue, V> converter;
        private Reflect<T, V> reflect;
        private DynamoDbAttributeType attributeType;
        private Class<T> targetType;

        Builder(Class<T> targetType, Properties<V> properties) {
            this.properties = properties;
            this.targetType = targetType;
        }

        public final Builder<T, V> with(DynamoDbTypeConverter<AttributeValue, V> converter) {
            this.converter = converter;
            return this;
        }

        public final Builder<T, V> with(DynamoDbAttributeType attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        public final Builder<T, V> with(Reflect<T, V> reflect) {
            this.reflect = reflect;
            return this;
        }

        public final DynamoDbMapperFieldModel<T, V> build() {
            DynamoDbMapperFieldModel result = new DynamoDbMapperFieldModel(this);
            if ((result.keyType() != null || result.indexed()) && !result.attributeType().name().matches("[BNS]")) {
                throw new DynamoDbMappingException(String.format("%s[%s]; only scalar (B, N, or S) type allowed for key", this.targetType.getSimpleName(), result.name()));
            }
            if (result.keyType() != null && result.getGenerateStrategy() == DynamoDbAutoGenerateStrategy.ALWAYS) {
                throw new DynamoDbMappingException(String.format("%s[%s]; auto-generated key and ALWAYS not allowed", this.targetType.getSimpleName(), result.name()));
            }
            return result;
        }
    }

    static interface Reflect<T, V> {
        public V get(T var1);

        public void set(T var1, V var2);
    }

    static interface Properties<V> {
        public String attributeName();

        public KeyType keyType();

        public boolean versioned();

        public Map<KeyType, List<String>> globalSecondaryIndexNames();

        public List<String> localSecondaryIndexNames();

        public DynamoDbAutoGenerator<V> autoGenerator();

        public static final class Immutable<V>
        implements Properties<V> {
            private final String attributeName;
            private final KeyType keyType;
            private final boolean versioned;
            private final Map<KeyType, List<String>> globalSecondaryIndexNames;
            private final List<String> localSecondaryIndexNames;
            private final DynamoDbAutoGenerator<V> autoGenerator;

            Immutable(Properties<V> properties) {
                this.attributeName = properties.attributeName();
                this.keyType = properties.keyType();
                this.versioned = properties.versioned();
                this.globalSecondaryIndexNames = properties.globalSecondaryIndexNames();
                this.localSecondaryIndexNames = properties.localSecondaryIndexNames();
                this.autoGenerator = properties.autoGenerator();
            }

            @Override
            public String attributeName() {
                return this.attributeName;
            }

            @Override
            public KeyType keyType() {
                return this.keyType;
            }

            @Override
            public boolean versioned() {
                return this.versioned;
            }

            @Override
            public Map<KeyType, List<String>> globalSecondaryIndexNames() {
                return this.globalSecondaryIndexNames;
            }

            @Override
            public List<String> localSecondaryIndexNames() {
                return this.localSecondaryIndexNames;
            }

            @Override
            public DynamoDbAutoGenerator<V> autoGenerator() {
                return this.autoGenerator;
            }
        }
    }

    public static enum DynamoDbAttributeType {
        B,
        N,
        S,
        BS,
        NS,
        SS,
        BOOL,
        NULL,
        L,
        M;

    }
}

