/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.datamodeling.AttributeTransformer;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AttributeTransformerChain
implements AttributeTransformer {
    private final List<AttributeTransformer> transformers;

    public AttributeTransformerChain(AttributeTransformer ... transformers) {
        this(Arrays.asList(transformers));
    }

    public AttributeTransformerChain(List<AttributeTransformer> transformers) {
        this.transformers = Collections.unmodifiableList(new ArrayList<AttributeTransformer>(transformers));
    }

    public List<AttributeTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    public Map<String, AttributeValue> transform(AttributeTransformer.Parameters<?> parameters) {
        ProxyParameters proxy = new ProxyParameters(parameters);
        for (int i = 0; i < this.transformers.size(); ++i) {
            proxy.setAttributeValues(this.transformers.get(i).transform(proxy));
        }
        return proxy.getAttributeValues();
    }

    @Override
    public Map<String, AttributeValue> untransform(AttributeTransformer.Parameters<?> parameters) {
        ProxyParameters proxy = new ProxyParameters(parameters);
        for (int i = this.transformers.size() - 1; i >= 0; --i) {
            proxy.setAttributeValues(this.transformers.get(i).untransform(proxy));
        }
        return proxy.getAttributeValues();
    }

    public String toString() {
        return this.transformers.toString();
    }

    private static class ProxyParameters<T>
    implements AttributeTransformer.Parameters<T> {
        private final AttributeTransformer.Parameters<T> delegate;
        private Map<String, AttributeValue> values;

        ProxyParameters(AttributeTransformer.Parameters<T> delegate) {
            this.delegate = delegate;
            this.values = delegate.getAttributeValues();
        }

        @Override
        public Map<String, AttributeValue> getAttributeValues() {
            return this.values;
        }

        public void setAttributeValues(Map<String, AttributeValue> values) {
            this.values = Collections.unmodifiableMap(values);
        }

        @Override
        public boolean isPartialUpdate() {
            return this.delegate.isPartialUpdate();
        }

        @Override
        public Class<T> modelClass() {
            return this.delegate.modelClass();
        }

        @Override
        public DynamoDbMapperConfig mapperConfig() {
            return this.delegate.mapperConfig();
        }

        @Override
        public String getTableName() {
            return this.delegate.getTableName();
        }

        @Override
        public String getHashKeyName() {
            return this.delegate.getHashKeyName();
        }

        @Override
        public String getRangeKeyName() {
            return this.delegate.getRangeKeyName();
        }
    }
}

