/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.SSESpecification;

public class SSESpecificationUnmarshaller
implements Unmarshaller<SSESpecification, JsonUnmarshallerContext> {
    private static final SSESpecificationUnmarshaller INSTANCE = new SSESpecificationUnmarshaller();

    public SSESpecification unmarshall(JsonUnmarshallerContext context) throws Exception {
        SSESpecification.Builder sseSpecificationBuilder = SSESpecification.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Enabled", targetDepth)) {
                    context.nextToken();
                    sseSpecificationBuilder.enabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("SSEType", targetDepth)) {
                    context.nextToken();
                    sseSpecificationBuilder.sseType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KMSMasterKeyId", targetDepth)) {
                    context.nextToken();
                    sseSpecificationBuilder.kmsMasterKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SSESpecification)sseSpecificationBuilder.build();
    }

    public static SSESpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

