/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RestoreTableFromBackupRequestModelMarshaller {
    private static final MarshallingInfo<String> TARGETTABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetTableName").isBinary(false).build();
    private static final MarshallingInfo<String> BACKUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupArn").isBinary(false).build();
    private static final RestoreTableFromBackupRequestModelMarshaller INSTANCE = new RestoreTableFromBackupRequestModelMarshaller();

    private RestoreTableFromBackupRequestModelMarshaller() {
    }

    public static RestoreTableFromBackupRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RestoreTableFromBackupRequest restoreTableFromBackupRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)restoreTableFromBackupRequest), (String)"restoreTableFromBackupRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)restoreTableFromBackupRequest.targetTableName(), TARGETTABLENAME_BINDING);
            protocolMarshaller.marshall((Object)restoreTableFromBackupRequest.backupArn(), BACKUPARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

