/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.Endpoint;

public class EndpointUnmarshaller
implements Unmarshaller<Endpoint, JsonUnmarshallerContext> {
    private static final EndpointUnmarshaller INSTANCE = new EndpointUnmarshaller();

    public Endpoint unmarshall(JsonUnmarshallerContext context) throws Exception {
        Endpoint.Builder endpointBuilder = Endpoint.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Address", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.address((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CachePeriodInMinutes", targetDepth)) {
                    context.nextToken();
                    endpointBuilder.cachePeriodInMinutes((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Endpoint)endpointBuilder.build();
    }

    public static EndpointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

