/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteTableRequestModelMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final DeleteTableRequestModelMarshaller INSTANCE = new DeleteTableRequestModelMarshaller();

    private DeleteTableRequestModelMarshaller() {
    }

    public static DeleteTableRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeleteTableRequest deleteTableRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)deleteTableRequest), (String)"deleteTableRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deleteTableRequest.tableName(), TABLENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

