/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AutoScalingPolicyUpdateMarshaller {
    private static final MarshallingInfo<String> POLICYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETTRACKINGSCALINGPOLICYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetTrackingScalingPolicyConfiguration").isBinary(false).build();
    private static final AutoScalingPolicyUpdateMarshaller INSTANCE = new AutoScalingPolicyUpdateMarshaller();

    private AutoScalingPolicyUpdateMarshaller() {
    }

    public static AutoScalingPolicyUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutoScalingPolicyUpdate autoScalingPolicyUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)autoScalingPolicyUpdate, (String)"autoScalingPolicyUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)autoScalingPolicyUpdate.policyName(), POLICYNAME_BINDING);
            protocolMarshaller.marshall((Object)autoScalingPolicyUpdate.targetTrackingScalingPolicyConfiguration(), TARGETTRACKINGSCALINGPOLICYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

