/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemListCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, QueryResponse> {
    private final List<Map<String, AttributeValue>> items;
    private final Integer count;
    private final Integer scannedCount;
    private final Map<String, AttributeValue> lastEvaluatedKey;
    private final ConsumedCapacity consumedCapacity;

    private QueryResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.count = builder.count;
        this.scannedCount = builder.scannedCount;
        this.lastEvaluatedKey = builder.lastEvaluatedKey;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public List<Map<String, AttributeValue>> items() {
        return this.items;
    }

    public Integer count() {
        return this.count;
    }

    public Integer scannedCount() {
        return this.scannedCount;
    }

    public Map<String, AttributeValue> lastEvaluatedKey() {
        return this.lastEvaluatedKey;
    }

    public ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.scannedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse)((Object)obj);
        return Objects.equals(this.items(), other.items()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.scannedCount(), other.scannedCount()) && Objects.equals(this.lastEvaluatedKey(), other.lastEvaluatedKey()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity());
    }

    public String toString() {
        return ToString.builder((String)"QueryResponse").add("Items", this.items()).add("Count", (Object)this.count()).add("ScannedCount", (Object)this.scannedCount()).add("LastEvaluatedKey", this.lastEvaluatedKey()).add("ConsumedCapacity", (Object)this.consumedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "ScannedCount": {
                return Optional.ofNullable(clazz.cast(this.scannedCount()));
            }
            case "LastEvaluatedKey": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedKey()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<Map<String, AttributeValue>> items = DefaultSdkAutoConstructList.getInstance();
        private Integer count;
        private Integer scannedCount;
        private Map<String, AttributeValue> lastEvaluatedKey = DefaultSdkAutoConstructMap.getInstance();
        private ConsumedCapacity consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            super(model);
            this.items(model.items);
            this.count(model.count);
            this.scannedCount(model.scannedCount);
            this.lastEvaluatedKey(model.lastEvaluatedKey);
            this.consumedCapacity(model.consumedCapacity);
        }

        public final Collection<Map<String, AttributeValue>> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Map<String, AttributeValue> ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Integer getScannedCount() {
            return this.scannedCount;
        }

        @Override
        public final Builder scannedCount(Integer scannedCount) {
            this.scannedCount = scannedCount;
            return this;
        }

        public final void setScannedCount(Integer scannedCount) {
            this.scannedCount = scannedCount;
        }

        public final Map<String, AttributeValue.Builder> getLastEvaluatedKey() {
            return this.lastEvaluatedKey != null ? CollectionUtils.mapValues(this.lastEvaluatedKey, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copy(lastEvaluatedKey);
            return this;
        }

        public final void setLastEvaluatedKey(Map<String, AttributeValue.BuilderImpl> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copyFromBuilder(lastEvaluatedKey);
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return this.consumedCapacity != null ? this.consumedCapacity.toBuilder() : null;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    CopyableBuilder<Builder, QueryResponse> {
        public Builder items(Collection<Map<String, AttributeValue>> var1);

        public Builder items(Map<String, AttributeValue> ... var1);

        public Builder count(Integer var1);

        public Builder scannedCount(Integer var1);

        public Builder lastEvaluatedKey(Map<String, AttributeValue> var1);

        public Builder consumedCapacity(ConsumedCapacity var1);

        default public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return this.consumedCapacity((ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation(consumedCapacity)).build());
        }
    }
}

