/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionKeyAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeEstimateRangeCopier;
import software.amazon.awssdk.services.dynamodb.transform.ItemCollectionMetricsMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemCollectionMetrics
implements StructuredPojo,
ToCopyableBuilder<Builder, ItemCollectionMetrics> {
    private final Map<String, AttributeValue> itemCollectionKey;
    private final List<Double> sizeEstimateRangeGB;

    private ItemCollectionMetrics(BuilderImpl builder) {
        this.itemCollectionKey = builder.itemCollectionKey;
        this.sizeEstimateRangeGB = builder.sizeEstimateRangeGB;
    }

    public Map<String, AttributeValue> itemCollectionKey() {
        return this.itemCollectionKey;
    }

    public List<Double> sizeEstimateRangeGB() {
        return this.sizeEstimateRangeGB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCollectionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeEstimateRangeGB());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemCollectionMetrics)) {
            return false;
        }
        ItemCollectionMetrics other = (ItemCollectionMetrics)obj;
        return Objects.equals(this.itemCollectionKey(), other.itemCollectionKey()) && Objects.equals(this.sizeEstimateRangeGB(), other.sizeEstimateRangeGB());
    }

    public String toString() {
        return ToString.builder((String)"ItemCollectionMetrics").add("ItemCollectionKey", this.itemCollectionKey()).add("SizeEstimateRangeGB", this.sizeEstimateRangeGB()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ItemCollectionKey": {
                return Optional.ofNullable(clazz.cast(this.itemCollectionKey()));
            }
            case "SizeEstimateRangeGB": {
                return Optional.ofNullable(clazz.cast(this.sizeEstimateRangeGB()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ItemCollectionMetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> itemCollectionKey = DefaultSdkAutoConstructMap.getInstance();
        private List<Double> sizeEstimateRangeGB = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ItemCollectionMetrics model) {
            this.itemCollectionKey(model.itemCollectionKey);
            this.sizeEstimateRangeGB(model.sizeEstimateRangeGB);
        }

        public final Map<String, AttributeValue.Builder> getItemCollectionKey() {
            return this.itemCollectionKey != null ? CollectionUtils.mapValues(this.itemCollectionKey, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder itemCollectionKey(Map<String, AttributeValue> itemCollectionKey) {
            this.itemCollectionKey = ItemCollectionKeyAttributeMapCopier.copy(itemCollectionKey);
            return this;
        }

        public final void setItemCollectionKey(Map<String, AttributeValue.BuilderImpl> itemCollectionKey) {
            this.itemCollectionKey = ItemCollectionKeyAttributeMapCopier.copyFromBuilder(itemCollectionKey);
        }

        public final Collection<Double> getSizeEstimateRangeGB() {
            return this.sizeEstimateRangeGB;
        }

        @Override
        public final Builder sizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB = ItemCollectionSizeEstimateRangeCopier.copy(sizeEstimateRangeGB);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeEstimateRangeGB(Double ... sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB(Arrays.asList(sizeEstimateRangeGB));
            return this;
        }

        public final void setSizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB = ItemCollectionSizeEstimateRangeCopier.copy(sizeEstimateRangeGB);
        }

        public ItemCollectionMetrics build() {
            return new ItemCollectionMetrics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ItemCollectionMetrics> {
        public Builder itemCollectionKey(Map<String, AttributeValue> var1);

        public Builder sizeEstimateRangeGB(Collection<Double> var1);

        public Builder sizeEstimateRangeGB(Double ... var1);
    }
}

