/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLimitsResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, DescribeLimitsResponse> {
    private final Long accountMaxReadCapacityUnits;
    private final Long accountMaxWriteCapacityUnits;
    private final Long tableMaxReadCapacityUnits;
    private final Long tableMaxWriteCapacityUnits;

    private DescribeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.accountMaxReadCapacityUnits = builder.accountMaxReadCapacityUnits;
        this.accountMaxWriteCapacityUnits = builder.accountMaxWriteCapacityUnits;
        this.tableMaxReadCapacityUnits = builder.tableMaxReadCapacityUnits;
        this.tableMaxWriteCapacityUnits = builder.tableMaxWriteCapacityUnits;
    }

    public Long accountMaxReadCapacityUnits() {
        return this.accountMaxReadCapacityUnits;
    }

    public Long accountMaxWriteCapacityUnits() {
        return this.accountMaxWriteCapacityUnits;
    }

    public Long tableMaxReadCapacityUnits() {
        return this.tableMaxReadCapacityUnits;
    }

    public Long tableMaxWriteCapacityUnits() {
        return this.tableMaxWriteCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountMaxReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountMaxWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMaxReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMaxWriteCapacityUnits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse)((Object)obj);
        return Objects.equals(this.accountMaxReadCapacityUnits(), other.accountMaxReadCapacityUnits()) && Objects.equals(this.accountMaxWriteCapacityUnits(), other.accountMaxWriteCapacityUnits()) && Objects.equals(this.tableMaxReadCapacityUnits(), other.tableMaxReadCapacityUnits()) && Objects.equals(this.tableMaxWriteCapacityUnits(), other.tableMaxWriteCapacityUnits());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLimitsResponse").add("AccountMaxReadCapacityUnits", (Object)this.accountMaxReadCapacityUnits()).add("AccountMaxWriteCapacityUnits", (Object)this.accountMaxWriteCapacityUnits()).add("TableMaxReadCapacityUnits", (Object)this.tableMaxReadCapacityUnits()).add("TableMaxWriteCapacityUnits", (Object)this.tableMaxWriteCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountMaxReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.accountMaxReadCapacityUnits()));
            }
            case "AccountMaxWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.accountMaxWriteCapacityUnits()));
            }
            case "TableMaxReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.tableMaxReadCapacityUnits()));
            }
            case "TableMaxWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.tableMaxWriteCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private Long accountMaxReadCapacityUnits;
        private Long accountMaxWriteCapacityUnits;
        private Long tableMaxReadCapacityUnits;
        private Long tableMaxWriteCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            super(model);
            this.accountMaxReadCapacityUnits(model.accountMaxReadCapacityUnits);
            this.accountMaxWriteCapacityUnits(model.accountMaxWriteCapacityUnits);
            this.tableMaxReadCapacityUnits(model.tableMaxReadCapacityUnits);
            this.tableMaxWriteCapacityUnits(model.tableMaxWriteCapacityUnits);
        }

        public final Long getAccountMaxReadCapacityUnits() {
            return this.accountMaxReadCapacityUnits;
        }

        @Override
        public final Builder accountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
            return this;
        }

        public final void setAccountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
        }

        public final Long getAccountMaxWriteCapacityUnits() {
            return this.accountMaxWriteCapacityUnits;
        }

        @Override
        public final Builder accountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
            return this;
        }

        public final void setAccountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
        }

        public final Long getTableMaxReadCapacityUnits() {
            return this.tableMaxReadCapacityUnits;
        }

        @Override
        public final Builder tableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
            return this;
        }

        public final void setTableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
        }

        public final Long getTableMaxWriteCapacityUnits() {
            return this.tableMaxWriteCapacityUnits;
        }

        @Override
        public final Builder tableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
            return this;
        }

        public final void setTableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
        }

        @Override
        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    CopyableBuilder<Builder, DescribeLimitsResponse> {
        public Builder accountMaxReadCapacityUnits(Long var1);

        public Builder accountMaxWriteCapacityUnits(Long var1);

        public Builder tableMaxReadCapacityUnits(Long var1);

        public Builder tableMaxWriteCapacityUnits(Long var1);
    }
}

