/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.BackupDetails;
import software.amazon.awssdk.services.dynamodb.model.SourceTableDetails;
import software.amazon.awssdk.services.dynamodb.model.SourceTableFeatureDetails;
import software.amazon.awssdk.services.dynamodb.transform.BackupDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, BackupDescription> {
    private final BackupDetails backupDetails;
    private final SourceTableDetails sourceTableDetails;
    private final SourceTableFeatureDetails sourceTableFeatureDetails;

    private BackupDescription(BuilderImpl builder) {
        this.backupDetails = builder.backupDetails;
        this.sourceTableDetails = builder.sourceTableDetails;
        this.sourceTableFeatureDetails = builder.sourceTableFeatureDetails;
    }

    public BackupDetails backupDetails() {
        return this.backupDetails;
    }

    public SourceTableDetails sourceTableDetails() {
        return this.sourceTableDetails;
    }

    public SourceTableFeatureDetails sourceTableFeatureDetails() {
        return this.sourceTableFeatureDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableFeatureDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupDescription)) {
            return false;
        }
        BackupDescription other = (BackupDescription)obj;
        return Objects.equals(this.backupDetails(), other.backupDetails()) && Objects.equals(this.sourceTableDetails(), other.sourceTableDetails()) && Objects.equals(this.sourceTableFeatureDetails(), other.sourceTableFeatureDetails());
    }

    public String toString() {
        return ToString.builder((String)"BackupDescription").add("BackupDetails", (Object)this.backupDetails()).add("SourceTableDetails", (Object)this.sourceTableDetails()).add("SourceTableFeatureDetails", (Object)this.sourceTableFeatureDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupDetails": {
                return Optional.ofNullable(clazz.cast(this.backupDetails()));
            }
            case "SourceTableDetails": {
                return Optional.ofNullable(clazz.cast(this.sourceTableDetails()));
            }
            case "SourceTableFeatureDetails": {
                return Optional.ofNullable(clazz.cast(this.sourceTableFeatureDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BackupDetails backupDetails;
        private SourceTableDetails sourceTableDetails;
        private SourceTableFeatureDetails sourceTableFeatureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupDescription model) {
            this.backupDetails(model.backupDetails);
            this.sourceTableDetails(model.sourceTableDetails);
            this.sourceTableFeatureDetails(model.sourceTableFeatureDetails);
        }

        public final BackupDetails.Builder getBackupDetails() {
            return this.backupDetails != null ? this.backupDetails.toBuilder() : null;
        }

        @Override
        public final Builder backupDetails(BackupDetails backupDetails) {
            this.backupDetails = backupDetails;
            return this;
        }

        public final void setBackupDetails(BackupDetails.BuilderImpl backupDetails) {
            this.backupDetails = backupDetails != null ? backupDetails.build() : null;
        }

        public final SourceTableDetails.Builder getSourceTableDetails() {
            return this.sourceTableDetails != null ? this.sourceTableDetails.toBuilder() : null;
        }

        @Override
        public final Builder sourceTableDetails(SourceTableDetails sourceTableDetails) {
            this.sourceTableDetails = sourceTableDetails;
            return this;
        }

        public final void setSourceTableDetails(SourceTableDetails.BuilderImpl sourceTableDetails) {
            this.sourceTableDetails = sourceTableDetails != null ? sourceTableDetails.build() : null;
        }

        public final SourceTableFeatureDetails.Builder getSourceTableFeatureDetails() {
            return this.sourceTableFeatureDetails != null ? this.sourceTableFeatureDetails.toBuilder() : null;
        }

        @Override
        public final Builder sourceTableFeatureDetails(SourceTableFeatureDetails sourceTableFeatureDetails) {
            this.sourceTableFeatureDetails = sourceTableFeatureDetails;
            return this;
        }

        public final void setSourceTableFeatureDetails(SourceTableFeatureDetails.BuilderImpl sourceTableFeatureDetails) {
            this.sourceTableFeatureDetails = sourceTableFeatureDetails != null ? sourceTableFeatureDetails.build() : null;
        }

        public BackupDescription build() {
            return new BackupDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BackupDescription> {
        public Builder backupDetails(BackupDetails var1);

        default public Builder backupDetails(Consumer<BackupDetails.Builder> backupDetails) {
            return this.backupDetails((BackupDetails)((BackupDetails.Builder)BackupDetails.builder().applyMutation(backupDetails)).build());
        }

        public Builder sourceTableDetails(SourceTableDetails var1);

        default public Builder sourceTableDetails(Consumer<SourceTableDetails.Builder> sourceTableDetails) {
            return this.sourceTableDetails((SourceTableDetails)((SourceTableDetails.Builder)SourceTableDetails.builder().applyMutation(sourceTableDetails)).build());
        }

        public Builder sourceTableFeatureDetails(SourceTableFeatureDetails var1);

        default public Builder sourceTableFeatureDetails(Consumer<SourceTableFeatureDetails.Builder> sourceTableFeatureDetails) {
            return this.sourceTableFeatureDetails((SourceTableFeatureDetails)((SourceTableFeatureDetails.Builder)SourceTableFeatureDetails.builder().applyMutation(sourceTableFeatureDetails)).build());
        }
    }
}

