/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription;
import software.amazon.awssdk.services.dynamodb.transform.AutoScalingPolicyDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingPolicyDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingPolicyDescription> {
    private final String policyName;
    private final AutoScalingTargetTrackingScalingPolicyConfigurationDescription targetTrackingScalingPolicyConfiguration;

    private AutoScalingPolicyDescription(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
    }

    public String policyName() {
        return this.policyName;
    }

    public AutoScalingTargetTrackingScalingPolicyConfigurationDescription targetTrackingScalingPolicyConfiguration() {
        return this.targetTrackingScalingPolicyConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingScalingPolicyConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyDescription)) {
            return false;
        }
        AutoScalingPolicyDescription other = (AutoScalingPolicyDescription)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.targetTrackingScalingPolicyConfiguration(), other.targetTrackingScalingPolicyConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingPolicyDescription").add("PolicyName", (Object)this.policyName()).add("TargetTrackingScalingPolicyConfiguration", (Object)this.targetTrackingScalingPolicyConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "TargetTrackingScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingScalingPolicyConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingPolicyDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private AutoScalingTargetTrackingScalingPolicyConfigurationDescription targetTrackingScalingPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyDescription model) {
            this.policyName(model.policyName);
            this.targetTrackingScalingPolicyConfiguration(model.targetTrackingScalingPolicyConfiguration);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final AutoScalingTargetTrackingScalingPolicyConfigurationDescription.Builder getTargetTrackingScalingPolicyConfiguration() {
            return this.targetTrackingScalingPolicyConfiguration != null ? this.targetTrackingScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationDescription targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        public final void setTargetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationDescription.BuilderImpl targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration.build() : null;
        }

        public AutoScalingPolicyDescription build() {
            return new AutoScalingPolicyDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingPolicyDescription> {
        public Builder policyName(String var1);

        public Builder targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationDescription var1);

        default public Builder targetTrackingScalingPolicyConfiguration(Consumer<AutoScalingTargetTrackingScalingPolicyConfigurationDescription.Builder> targetTrackingScalingPolicyConfiguration) {
            return this.targetTrackingScalingPolicyConfiguration((AutoScalingTargetTrackingScalingPolicyConfigurationDescription)((AutoScalingTargetTrackingScalingPolicyConfigurationDescription.Builder)AutoScalingTargetTrackingScalingPolicyConfigurationDescription.builder().applyMutation(targetTrackingScalingPolicyConfiguration)).build());
        }
    }
}

