/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateTimeToLiveRequestModelMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMETOLIVESPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeToLiveSpecification").isBinary(false).build();
    private static final UpdateTimeToLiveRequestModelMarshaller INSTANCE = new UpdateTimeToLiveRequestModelMarshaller();

    private UpdateTimeToLiveRequestModelMarshaller() {
    }

    public static UpdateTimeToLiveRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateTimeToLiveRequest updateTimeToLiveRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateTimeToLiveRequest), (String)"updateTimeToLiveRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateTimeToLiveRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)updateTimeToLiveRequest.timeToLiveSpecification(), TIMETOLIVESPECIFICATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

