/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.SequenceNumberRange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SequenceNumberRangeMarshaller {
    private static final MarshallingInfo<String> STARTINGSEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingSequenceNumber").isBinary(false).build();
    private static final MarshallingInfo<String> ENDINGSEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndingSequenceNumber").isBinary(false).build();
    private static final SequenceNumberRangeMarshaller INSTANCE = new SequenceNumberRangeMarshaller();

    private SequenceNumberRangeMarshaller() {
    }

    public static SequenceNumberRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SequenceNumberRange sequenceNumberRange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sequenceNumberRange, (String)"sequenceNumberRange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sequenceNumberRange.startingSequenceNumber(), STARTINGSEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)sequenceNumberRange.endingSequenceNumber(), ENDINGSEQUENCENUMBER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

