/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GlobalTableDescriptionMarshaller {
    private static final MarshallingInfo<List> REPLICATIONGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationGroup").isBinary(false).build();
    private static final MarshallingInfo<String> GLOBALTABLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalTableArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").isBinary(false).build();
    private static final MarshallingInfo<String> GLOBALTABLESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalTableStatus").isBinary(false).build();
    private static final MarshallingInfo<String> GLOBALTABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalTableName").isBinary(false).build();
    private static final GlobalTableDescriptionMarshaller INSTANCE = new GlobalTableDescriptionMarshaller();

    private GlobalTableDescriptionMarshaller() {
    }

    public static GlobalTableDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GlobalTableDescription globalTableDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)globalTableDescription, (String)"globalTableDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(globalTableDescription.replicationGroup(), REPLICATIONGROUP_BINDING);
            protocolMarshaller.marshall((Object)globalTableDescription.globalTableArn(), GLOBALTABLEARN_BINDING);
            protocolMarshaller.marshall((Object)globalTableDescription.creationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)globalTableDescription.globalTableStatusAsString(), GLOBALTABLESTATUS_BINDING);
            protocolMarshaller.marshall((Object)globalTableDescription.globalTableName(), GLOBALTABLENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

