/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GlobalSecondaryIndexUpdateMarshaller {
    private static final MarshallingInfo<StructuredPojo> UPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Update").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CREATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Create").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DELETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Delete").isBinary(false).build();
    private static final GlobalSecondaryIndexUpdateMarshaller INSTANCE = new GlobalSecondaryIndexUpdateMarshaller();

    private GlobalSecondaryIndexUpdateMarshaller() {
    }

    public static GlobalSecondaryIndexUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GlobalSecondaryIndexUpdate globalSecondaryIndexUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)globalSecondaryIndexUpdate, (String)"globalSecondaryIndexUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)globalSecondaryIndexUpdate.update(), UPDATE_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexUpdate.create(), CREATE_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexUpdate.delete(), DELETE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

