/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttributeValueUpdateMarshaller {
    private static final MarshallingInfo<StructuredPojo> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final AttributeValueUpdateMarshaller INSTANCE = new AttributeValueUpdateMarshaller();

    private AttributeValueUpdateMarshaller() {
    }

    public static AttributeValueUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttributeValueUpdate attributeValueUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attributeValueUpdate, (String)"attributeValueUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attributeValueUpdate.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)attributeValueUpdate.actionAsString(), ACTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

