/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsAsyncClient;

public class DescribeStreamPublisher
implements SdkPublisher<DescribeStreamResponse> {
    private final DynamoDbStreamsAsyncClient client;
    private final DescribeStreamRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStreamPublisher(DynamoDbStreamsAsyncClient client, DescribeStreamRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStreamPublisher(DynamoDbStreamsAsyncClient client, DescribeStreamRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStreamResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStreamResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Shard> shards() {
        Function<DescribeStreamResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamDescription() != null && response.streamDescription().shards() != null) {
                return response.streamDescription().shards().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeStreamResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeStreamPublisher resume(DescribeStreamResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeStreamPublisher(this.client, (DescribeStreamRequest)((Object)this.firstRequest.toBuilder().exclusiveStartShardId(lastSuccessfulPage.streamDescription().lastEvaluatedShardId()).build()));
        }
        return new DescribeStreamPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeStreamResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeStreamResponseFetcher
    implements AsyncPageFetcher<DescribeStreamResponse> {
        private DescribeStreamResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStreamResponse previousPage) {
            return previousPage.streamDescription().lastEvaluatedShardId() != null && !SdkAutoConstructList.class.isInstance(previousPage.streamDescription().lastEvaluatedShardId()) && !SdkAutoConstructMap.class.isInstance(previousPage.streamDescription().lastEvaluatedShardId());
        }

        public CompletableFuture<DescribeStreamResponse> nextPage(DescribeStreamResponse previousPage) {
            if (previousPage == null) {
                return DescribeStreamPublisher.this.client.describeStream(DescribeStreamPublisher.this.firstRequest);
            }
            return DescribeStreamPublisher.this.client.describeStream((DescribeStreamRequest)((Object)DescribeStreamPublisher.this.firstRequest.toBuilder().exclusiveStartShardId(previousPage.streamDescription().lastEvaluatedShardId()).build()));
        }
    }
}

