/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.ReplicaGlobalSecondaryIndexSettingsUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaGlobalSecondaryIndexSettingsUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsUpdate> {
    private final String indexName;
    private final Long provisionedReadCapacityUnits;

    private ReplicaGlobalSecondaryIndexSettingsUpdate(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedReadCapacityUnits = builder.provisionedReadCapacityUnits;
    }

    public String indexName() {
        return this.indexName;
    }

    public Long provisionedReadCapacityUnits() {
        return this.provisionedReadCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedReadCapacityUnits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndexSettingsUpdate)) {
            return false;
        }
        ReplicaGlobalSecondaryIndexSettingsUpdate other = (ReplicaGlobalSecondaryIndexSettingsUpdate)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.provisionedReadCapacityUnits(), other.provisionedReadCapacityUnits());
    }

    public String toString() {
        return ToString.builder((String)"ReplicaGlobalSecondaryIndexSettingsUpdate").add("IndexName", (Object)this.indexName()).add("ProvisionedReadCapacityUnits", (Object)this.provisionedReadCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "ProvisionedReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.provisionedReadCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicaGlobalSecondaryIndexSettingsUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private Long provisionedReadCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndexSettingsUpdate model) {
            this.indexName(model.indexName);
            this.provisionedReadCapacityUnits(model.provisionedReadCapacityUnits);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Long getProvisionedReadCapacityUnits() {
            return this.provisionedReadCapacityUnits;
        }

        @Override
        public final Builder provisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
            return this;
        }

        public final void setProvisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
        }

        public ReplicaGlobalSecondaryIndexSettingsUpdate build() {
            return new ReplicaGlobalSecondaryIndexSettingsUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsUpdate> {
        public Builder indexName(String var1);

        public Builder provisionedReadCapacityUnits(Long var1);
    }
}

