/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodbstreams;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.config.AwsSyncClientConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBException;
import software.amazon.awssdk.services.dynamodb.model.ExpiredIteratorException;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;
import software.amazon.awssdk.services.dynamodb.transform.DescribeStreamResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetRecordsResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetShardIteratorResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListStreamsResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodbstreams.DynamoDBStreamsClient;
import software.amazon.awssdk.services.dynamodbstreams.paginators.DescribeStreamIterable;
import software.amazon.awssdk.services.dynamodbstreams.paginators.ListStreamsIterable;
import software.amazon.awssdk.services.dynamodbstreams.transform.DescribeStreamRequestMarshaller;
import software.amazon.awssdk.services.dynamodbstreams.transform.GetRecordsRequestMarshaller;
import software.amazon.awssdk.services.dynamodbstreams.transform.GetShardIteratorRequestMarshaller;
import software.amazon.awssdk.services.dynamodbstreams.transform.ListStreamsRequestMarshaller;

@SdkInternalApi
final class DefaultDynamoDBStreamsClient
implements DynamoDBStreamsClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final AwsSyncClientConfiguration clientConfiguration;

    protected DefaultDynamoDBStreamsClient(AwsSyncClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "dynamodb";
    }

    @Override
    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStreamRequest).withMarshaller((Marshaller)new DescribeStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeStreamIterable describeStreamPaginator(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        return new DescribeStreamIterable(this, describeStreamRequest);
    }

    @Override
    public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ResourceNotFoundException, LimitExceededException, InternalServerErrorException, ExpiredIteratorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDBException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecordsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRecordsRequest).withMarshaller((Marshaller)new GetRecordsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws ResourceNotFoundException, InternalServerErrorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDBException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetShardIteratorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetShardIteratorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getShardIteratorRequest).withMarshaller((Marshaller)new GetShardIteratorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStreamsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStreamsRequest).withMarshaller((Marshaller)new ListStreamsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListStreamsIterable listStreamsPaginator(ListStreamsRequest listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        return new ListStreamsIterable(this, listStreamsRequest);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(DynamoDBException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TrimmedDataAccessException").withModeledClass(TrimmedDataAccessException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredIteratorException").withModeledClass(ExpiredIteratorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.0").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

