/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WriteRequestMarshaller {
    private static final MarshallingInfo<StructuredPojo> PUTREQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PutRequest").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DELETEREQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteRequest").isBinary(false).build();
    private static final WriteRequestMarshaller INSTANCE = new WriteRequestMarshaller();

    private WriteRequestMarshaller() {
    }

    public static WriteRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WriteRequest writeRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)writeRequest, (String)"writeRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)writeRequest.putRequest(), PUTREQUEST_BINDING);
            protocolMarshaller.marshall((Object)writeRequest.deleteRequest(), DELETEREQUEST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

