/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamSpecificationMarshaller {
    private static final MarshallingInfo<Boolean> STREAMENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamEnabled").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMVIEWTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamViewType").isBinary(false).build();
    private static final StreamSpecificationMarshaller INSTANCE = new StreamSpecificationMarshaller();

    private StreamSpecificationMarshaller() {
    }

    public static StreamSpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamSpecification streamSpecification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamSpecification, (String)"streamSpecification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamSpecification.streamEnabled(), STREAMENABLED_BINDING);
            protocolMarshaller.marshall((Object)streamSpecification.streamViewTypeAsString(), STREAMVIEWTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

