/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamRecordMarshaller {
    private static final MarshallingInfo<Instant> APPROXIMATECREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApproximateCreationDateTime").isBinary(false).build();
    private static final MarshallingInfo<Map> KEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keys").isBinary(false).build();
    private static final MarshallingInfo<Map> NEWIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewImage").isBinary(false).build();
    private static final MarshallingInfo<Map> OLDIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OldImage").isBinary(false).build();
    private static final MarshallingInfo<String> SEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumber").isBinary(false).build();
    private static final MarshallingInfo<Long> SIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeBytes").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMVIEWTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamViewType").isBinary(false).build();
    private static final StreamRecordMarshaller INSTANCE = new StreamRecordMarshaller();

    private StreamRecordMarshaller() {
    }

    public static StreamRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamRecord streamRecord, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamRecord, (String)"streamRecord");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamRecord.approximateCreationDateTime(), APPROXIMATECREATIONDATETIME_BINDING);
            protocolMarshaller.marshall(streamRecord.keys(), KEYS_BINDING);
            protocolMarshaller.marshall(streamRecord.newImage(), NEWIMAGE_BINDING);
            protocolMarshaller.marshall(streamRecord.oldImage(), OLDIMAGE_BINDING);
            protocolMarshaller.marshall((Object)streamRecord.sequenceNumber(), SEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)streamRecord.sizeBytes(), SIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)streamRecord.streamViewTypeAsString(), STREAMVIEWTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

