/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProvisionedThroughputDescriptionMarshaller {
    private static final MarshallingInfo<Instant> LASTINCREASEDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastIncreaseDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTDECREASEDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastDecreaseDateTime").isBinary(false).build();
    private static final MarshallingInfo<Long> NUMBEROFDECREASESTODAY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfDecreasesToday").isBinary(false).build();
    private static final MarshallingInfo<Long> READCAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadCapacityUnits").isBinary(false).build();
    private static final MarshallingInfo<Long> WRITECAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WriteCapacityUnits").isBinary(false).build();
    private static final ProvisionedThroughputDescriptionMarshaller INSTANCE = new ProvisionedThroughputDescriptionMarshaller();

    private ProvisionedThroughputDescriptionMarshaller() {
    }

    public static ProvisionedThroughputDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProvisionedThroughputDescription provisionedThroughputDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)provisionedThroughputDescription, (String)"provisionedThroughputDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.lastIncreaseDateTime(), LASTINCREASEDATETIME_BINDING);
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.lastDecreaseDateTime(), LASTDECREASEDATETIME_BINDING);
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.numberOfDecreasesToday(), NUMBEROFDECREASESTODAY_BINDING);
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.readCapacityUnits(), READCAPACITYUNITS_BINDING);
            protocolMarshaller.marshall((Object)provisionedThroughputDescription.writeCapacityUnits(), WRITECAPACITYUNITS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

