/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListTablesRequestModelMarshaller {
    private static final MarshallingInfo<String> EXCLUSIVESTARTTABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusiveStartTableName").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final ListTablesRequestModelMarshaller INSTANCE = new ListTablesRequestModelMarshaller();

    private ListTablesRequestModelMarshaller() {
    }

    public static ListTablesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListTablesRequest listTablesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listTablesRequest), (String)"listTablesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listTablesRequest.exclusiveStartTableName(), EXCLUSIVESTARTTABLENAME_BINDING);
            protocolMarshaller.marshall((Object)listTablesRequest.limit(), LIMIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

