/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;

public class ListTablesIterable
implements SdkIterable<ListTablesResponse> {
    private final DynamoDBClient client;
    private final ListTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTablesIterable(DynamoDBClient client, ListTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTablesResponseFetcher();
    }

    public Iterator<ListTablesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<String> tableNames() {
        Function<ListTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableNames() != null) {
                return response.tableNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListTablesIterable resume(ListTablesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTablesIterable(this.client, (ListTablesRequest)((Object)this.firstRequest.toBuilder().exclusiveStartTableName(lastSuccessfulPage.lastEvaluatedTableName()).build()));
        }
        return new ListTablesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTablesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTablesResponseFetcher
    implements SyncPageFetcher<ListTablesResponse> {
        private ListTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListTablesResponse previousPage) {
            return previousPage.lastEvaluatedTableName() != null;
        }

        public ListTablesResponse nextPage(ListTablesResponse previousPage) {
            if (previousPage == null) {
                return ListTablesIterable.this.client.listTables(ListTablesIterable.this.firstRequest);
            }
            return ListTablesIterable.this.client.listTables((ListTablesRequest)((Object)ListTablesIterable.this.firstRequest.toBuilder().exclusiveStartTableName(previousPage.lastEvaluatedTableName()).build()));
        }
    }
}

