/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dynamodb.model.AttributeUpdatesCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateItemRequest
extends DynamoDBRequest
implements ToCopyableBuilder<Builder, UpdateItemRequest> {
    private final String tableName;
    private final Map<String, AttributeValue> key;
    private final Map<String, AttributeValueUpdate> attributeUpdates;
    private final Map<String, ExpectedAttributeValue> expected;
    private final String conditionalOperator;
    private final String returnValues;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;
    private final String updateExpression;
    private final String conditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;

    private UpdateItemRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.key = builder.key;
        this.attributeUpdates = builder.attributeUpdates;
        this.expected = builder.expected;
        this.conditionalOperator = builder.conditionalOperator;
        this.returnValues = builder.returnValues;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.updateExpression = builder.updateExpression;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    public String tableName() {
        return this.tableName;
    }

    public Map<String, AttributeValue> key() {
        return this.key;
    }

    public Map<String, AttributeValueUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public Map<String, ExpectedAttributeValue> expected() {
        return this.expected;
    }

    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(this.conditionalOperator);
    }

    public String conditionalOperatorAsString() {
        return this.conditionalOperator;
    }

    public ReturnValue returnValues() {
        return ReturnValue.fromValue(this.returnValues);
    }

    public String returnValuesAsString() {
        return this.returnValues;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue(this.returnItemCollectionMetrics);
    }

    public String returnItemCollectionMetricsAsString() {
        return this.returnItemCollectionMetrics;
    }

    public String updateExpression() {
        return this.updateExpression;
    }

    public String conditionExpression() {
        return this.conditionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.expected());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValuesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnItemCollectionMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateItemRequest)) {
            return false;
        }
        UpdateItemRequest other = (UpdateItemRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.attributeUpdates(), other.attributeUpdates()) && Objects.equals(this.expected(), other.expected()) && Objects.equals(this.conditionalOperatorAsString(), other.conditionalOperatorAsString()) && Objects.equals(this.returnValuesAsString(), other.returnValuesAsString()) && Objects.equals(this.returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString()) && Objects.equals(this.returnItemCollectionMetricsAsString(), other.returnItemCollectionMetricsAsString()) && Objects.equals(this.updateExpression(), other.updateExpression()) && Objects.equals(this.conditionExpression(), other.conditionExpression()) && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames()) && Objects.equals(this.expressionAttributeValues(), other.expressionAttributeValues());
    }

    public String toString() {
        return ToString.builder((String)"UpdateItemRequest").add("TableName", (Object)this.tableName()).add("Key", this.key()).add("AttributeUpdates", this.attributeUpdates()).add("Expected", this.expected()).add("ConditionalOperator", (Object)this.conditionalOperatorAsString()).add("ReturnValues", (Object)this.returnValuesAsString()).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityAsString()).add("ReturnItemCollectionMetrics", (Object)this.returnItemCollectionMetricsAsString()).add("UpdateExpression", (Object)this.updateExpression()).add("ConditionExpression", (Object)this.conditionExpression()).add("ExpressionAttributeNames", this.expressionAttributeNames()).add("ExpressionAttributeValues", this.expressionAttributeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "AttributeUpdates": {
                return Optional.of(clazz.cast(this.attributeUpdates()));
            }
            case "Expected": {
                return Optional.of(clazz.cast(this.expected()));
            }
            case "ConditionalOperator": {
                return Optional.of(clazz.cast(this.conditionalOperatorAsString()));
            }
            case "ReturnValues": {
                return Optional.of(clazz.cast(this.returnValuesAsString()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.of(clazz.cast(this.returnConsumedCapacityAsString()));
            }
            case "ReturnItemCollectionMetrics": {
                return Optional.of(clazz.cast(this.returnItemCollectionMetricsAsString()));
            }
            case "UpdateExpression": {
                return Optional.of(clazz.cast(this.updateExpression()));
            }
            case "ConditionExpression": {
                return Optional.of(clazz.cast(this.conditionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.of(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.of(clazz.cast(this.expressionAttributeValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private Map<String, AttributeValue> key;
        private Map<String, AttributeValueUpdate> attributeUpdates;
        private Map<String, ExpectedAttributeValue> expected;
        private String conditionalOperator;
        private String returnValues;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;
        private String updateExpression;
        private String conditionExpression;
        private Map<String, String> expressionAttributeNames;
        private Map<String, AttributeValue> expressionAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateItemRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.key(model.key);
            this.attributeUpdates(model.attributeUpdates);
            this.expected(model.expected);
            this.conditionalOperator(model.conditionalOperator);
            this.returnValues(model.returnValues);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.returnItemCollectionMetrics(model.returnItemCollectionMetrics);
            this.updateExpression(model.updateExpression);
            this.conditionExpression(model.conditionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            return this.key != null ? CollectionUtils.mapValues(this.key, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        public final Map<String, AttributeValueUpdate.Builder> getAttributeUpdates() {
            return this.attributeUpdates != null ? CollectionUtils.mapValues(this.attributeUpdates, AttributeValueUpdate::toBuilder) : null;
        }

        @Override
        public final Builder attributeUpdates(Map<String, AttributeValueUpdate> attributeUpdates) {
            this.attributeUpdates = AttributeUpdatesCopier.copy(attributeUpdates);
            return this;
        }

        public final void setAttributeUpdates(Map<String, AttributeValueUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = AttributeUpdatesCopier.copyFromBuilder(attributeUpdates);
        }

        public final Map<String, ExpectedAttributeValue.Builder> getExpected() {
            return this.expected != null ? CollectionUtils.mapValues(this.expected, ExpectedAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
            return this;
        }

        public final void setExpected(Map<String, ExpectedAttributeValue.BuilderImpl> expected) {
            this.expected = ExpectedAttributeMapCopier.copyFromBuilder(expected);
        }

        public final String getConditionalOperator() {
            return this.conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final String getReturnValues() {
            return this.returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        @Override
        public final Builder returnValues(ReturnValue returnValues) {
            this.returnValues(returnValues.toString());
            return this;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public final String getUpdateExpression() {
            return this.updateExpression;
        }

        @Override
        public final Builder updateExpression(String updateExpression) {
            this.updateExpression = updateExpression;
            return this;
        }

        public final void setUpdateExpression(String updateExpression) {
            this.updateExpression = updateExpression;
        }

        public final String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return this.expressionAttributeValues != null ? CollectionUtils.mapValues(this.expressionAttributeValues, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateItemRequest build() {
            return new UpdateItemRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDBRequest.Builder,
    CopyableBuilder<Builder, UpdateItemRequest> {
        public Builder tableName(String var1);

        public Builder key(Map<String, AttributeValue> var1);

        public Builder attributeUpdates(Map<String, AttributeValueUpdate> var1);

        public Builder expected(Map<String, ExpectedAttributeValue> var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder returnValues(String var1);

        public Builder returnValues(ReturnValue var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder returnItemCollectionMetrics(String var1);

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics var1);

        public Builder updateExpression(String var1);

        public Builder conditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

