/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.waiters.DescribeTableFunction;
import software.amazon.awssdk.services.dynamodb.waiters.TableExists;
import software.amazon.awssdk.services.dynamodb.waiters.TableNotExists;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class DynamoDBClientWaiters {
    private final DynamoDBClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public DynamoDBClientWaiters(DynamoDBClient client) {
        this.client = client;
    }

    public Waiter<DescribeTableRequest> tableExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTableFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TableExists.IsACTIVEMatcher(), new TableExists.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(25), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTableRequest> tableNotExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTableFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TableNotExists.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(25), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }
}

