/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;

@SdkInternalApi
public class LocalSecondaryIndexMarshaller {
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").build();
    private static final MarshallingInfo<StructuredPojo> PROJECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Projection").build();
    private static final LocalSecondaryIndexMarshaller instance = new LocalSecondaryIndexMarshaller();

    public static LocalSecondaryIndexMarshaller getInstance() {
        return instance;
    }

    public void marshall(LocalSecondaryIndex localSecondaryIndex, ProtocolMarshaller protocolMarshaller) {
        if (localSecondaryIndex == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)localSecondaryIndex.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall(localSecondaryIndex.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)localSecondaryIndex.projection(), PROJECTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

