/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ItemListCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScanResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ScanResponse> {
    private final List<Map<String, AttributeValue>> items;
    private final Integer count;
    private final Integer scannedCount;
    private final Map<String, AttributeValue> lastEvaluatedKey;
    private final ConsumedCapacity consumedCapacity;

    private ScanResponse(BuilderImpl builder) {
        this.items = builder.items;
        this.count = builder.count;
        this.scannedCount = builder.scannedCount;
        this.lastEvaluatedKey = builder.lastEvaluatedKey;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public List<Map<String, AttributeValue>> items() {
        return this.items;
    }

    public Integer count() {
        return this.count;
    }

    public Integer scannedCount() {
        return this.scannedCount;
    }

    public Map<String, AttributeValue> lastEvaluatedKey() {
        return this.lastEvaluatedKey;
    }

    public ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        hashCode = 31 * hashCode + (this.count() == null ? 0 : this.count().hashCode());
        hashCode = 31 * hashCode + (this.scannedCount() == null ? 0 : this.scannedCount().hashCode());
        hashCode = 31 * hashCode + (this.lastEvaluatedKey() == null ? 0 : this.lastEvaluatedKey().hashCode());
        hashCode = 31 * hashCode + (this.consumedCapacity() == null ? 0 : this.consumedCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanResponse)) {
            return false;
        }
        ScanResponse other = (ScanResponse)((Object)obj);
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.scannedCount() == null ^ this.scannedCount() == null) {
            return false;
        }
        if (other.scannedCount() != null && !other.scannedCount().equals(this.scannedCount())) {
            return false;
        }
        if (other.lastEvaluatedKey() == null ^ this.lastEvaluatedKey() == null) {
            return false;
        }
        if (other.lastEvaluatedKey() != null && !other.lastEvaluatedKey().equals(this.lastEvaluatedKey())) {
            return false;
        }
        if (other.consumedCapacity() == null ^ this.consumedCapacity() == null) {
            return false;
        }
        return other.consumedCapacity() == null || other.consumedCapacity().equals(this.consumedCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (this.scannedCount() != null) {
            sb.append("ScannedCount: ").append(this.scannedCount()).append(",");
        }
        if (this.lastEvaluatedKey() != null) {
            sb.append("LastEvaluatedKey: ").append(this.lastEvaluatedKey()).append(",");
        }
        if (this.consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(this.consumedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Map<String, AttributeValue>> items;
        private Integer count;
        private Integer scannedCount;
        private Map<String, AttributeValue> lastEvaluatedKey;
        private ConsumedCapacity consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanResponse model) {
            this.setItems(model.items);
            this.setCount(model.count);
            this.setScannedCount(model.scannedCount);
            this.setLastEvaluatedKey(model.lastEvaluatedKey);
            this.setConsumedCapacity(model.consumedCapacity);
        }

        public final Collection<Map<String, AttributeValue>> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Map<String, AttributeValue> ... items) {
            if (this.items == null) {
                this.items = new ArrayList<Map<String, AttributeValue>>(items.length);
            }
            for (Map<String, AttributeValue> e : items) {
                this.items.add(AttributeMapCopier.copy(e));
            }
            return this;
        }

        public final void setItems(Collection<Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(Map<String, AttributeValue> ... items) {
            if (this.items == null) {
                this.items = new ArrayList<Map<String, AttributeValue>>(items.length);
            }
            for (Map<String, AttributeValue> e : items) {
                this.items.add(AttributeMapCopier.copy(e));
            }
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Integer getScannedCount() {
            return this.scannedCount;
        }

        @Override
        public final Builder scannedCount(Integer scannedCount) {
            this.scannedCount = scannedCount;
            return this;
        }

        public final void setScannedCount(Integer scannedCount) {
            this.scannedCount = scannedCount;
        }

        public final Map<String, AttributeValue> getLastEvaluatedKey() {
            return this.lastEvaluatedKey;
        }

        @Override
        public final Builder lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copy(lastEvaluatedKey);
            return this;
        }

        public final void setLastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copy(lastEvaluatedKey);
        }

        public final ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
        }

        public ScanResponse build() {
            return new ScanResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScanResponse> {
        public Builder items(Collection<Map<String, AttributeValue>> var1);

        public Builder items(Map<String, AttributeValue> ... var1);

        public Builder count(Integer var1);

        public Builder scannedCount(Integer var1);

        public Builder lastEvaluatedKey(Map<String, AttributeValue> var1);

        public Builder consumedCapacity(ConsumedCapacity var1);
    }
}

