/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.dynamodb.transform.ProvisionedThroughputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisionedThroughputDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ProvisionedThroughputDescription> {
    private final Date lastIncreaseDateTime;
    private final Date lastDecreaseDateTime;
    private final Long numberOfDecreasesToday;
    private final Long readCapacityUnits;
    private final Long writeCapacityUnits;

    private ProvisionedThroughputDescription(BuilderImpl builder) {
        this.lastIncreaseDateTime = builder.lastIncreaseDateTime;
        this.lastDecreaseDateTime = builder.lastDecreaseDateTime;
        this.numberOfDecreasesToday = builder.numberOfDecreasesToday;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    public Date lastIncreaseDateTime() {
        return this.lastIncreaseDateTime;
    }

    public Date lastDecreaseDateTime() {
        return this.lastDecreaseDateTime;
    }

    public Long numberOfDecreasesToday() {
        return this.numberOfDecreasesToday;
    }

    public Long readCapacityUnits() {
        return this.readCapacityUnits;
    }

    public Long writeCapacityUnits() {
        return this.writeCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lastIncreaseDateTime() == null ? 0 : this.lastIncreaseDateTime().hashCode());
        hashCode = 31 * hashCode + (this.lastDecreaseDateTime() == null ? 0 : this.lastDecreaseDateTime().hashCode());
        hashCode = 31 * hashCode + (this.numberOfDecreasesToday() == null ? 0 : this.numberOfDecreasesToday().hashCode());
        hashCode = 31 * hashCode + (this.readCapacityUnits() == null ? 0 : this.readCapacityUnits().hashCode());
        hashCode = 31 * hashCode + (this.writeCapacityUnits() == null ? 0 : this.writeCapacityUnits().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughputDescription)) {
            return false;
        }
        ProvisionedThroughputDescription other = (ProvisionedThroughputDescription)obj;
        if (other.lastIncreaseDateTime() == null ^ this.lastIncreaseDateTime() == null) {
            return false;
        }
        if (other.lastIncreaseDateTime() != null && !other.lastIncreaseDateTime().equals(this.lastIncreaseDateTime())) {
            return false;
        }
        if (other.lastDecreaseDateTime() == null ^ this.lastDecreaseDateTime() == null) {
            return false;
        }
        if (other.lastDecreaseDateTime() != null && !other.lastDecreaseDateTime().equals(this.lastDecreaseDateTime())) {
            return false;
        }
        if (other.numberOfDecreasesToday() == null ^ this.numberOfDecreasesToday() == null) {
            return false;
        }
        if (other.numberOfDecreasesToday() != null && !other.numberOfDecreasesToday().equals(this.numberOfDecreasesToday())) {
            return false;
        }
        if (other.readCapacityUnits() == null ^ this.readCapacityUnits() == null) {
            return false;
        }
        if (other.readCapacityUnits() != null && !other.readCapacityUnits().equals(this.readCapacityUnits())) {
            return false;
        }
        if (other.writeCapacityUnits() == null ^ this.writeCapacityUnits() == null) {
            return false;
        }
        return other.writeCapacityUnits() == null || other.writeCapacityUnits().equals(this.writeCapacityUnits());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lastIncreaseDateTime() != null) {
            sb.append("LastIncreaseDateTime: ").append(this.lastIncreaseDateTime()).append(",");
        }
        if (this.lastDecreaseDateTime() != null) {
            sb.append("LastDecreaseDateTime: ").append(this.lastDecreaseDateTime()).append(",");
        }
        if (this.numberOfDecreasesToday() != null) {
            sb.append("NumberOfDecreasesToday: ").append(this.numberOfDecreasesToday()).append(",");
        }
        if (this.readCapacityUnits() != null) {
            sb.append("ReadCapacityUnits: ").append(this.readCapacityUnits()).append(",");
        }
        if (this.writeCapacityUnits() != null) {
            sb.append("WriteCapacityUnits: ").append(this.writeCapacityUnits()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisionedThroughputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Date lastIncreaseDateTime;
        private Date lastDecreaseDateTime;
        private Long numberOfDecreasesToday;
        private Long readCapacityUnits;
        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughputDescription model) {
            this.setLastIncreaseDateTime(model.lastIncreaseDateTime);
            this.setLastDecreaseDateTime(model.lastDecreaseDateTime);
            this.setNumberOfDecreasesToday(model.numberOfDecreasesToday);
            this.setReadCapacityUnits(model.readCapacityUnits);
            this.setWriteCapacityUnits(model.writeCapacityUnits);
        }

        public final Date getLastIncreaseDateTime() {
            return this.lastIncreaseDateTime;
        }

        @Override
        public final Builder lastIncreaseDateTime(Date lastIncreaseDateTime) {
            this.lastIncreaseDateTime = StandardMemberCopier.copy((Date)lastIncreaseDateTime);
            return this;
        }

        public final void setLastIncreaseDateTime(Date lastIncreaseDateTime) {
            this.lastIncreaseDateTime = StandardMemberCopier.copy((Date)lastIncreaseDateTime);
        }

        public final Date getLastDecreaseDateTime() {
            return this.lastDecreaseDateTime;
        }

        @Override
        public final Builder lastDecreaseDateTime(Date lastDecreaseDateTime) {
            this.lastDecreaseDateTime = StandardMemberCopier.copy((Date)lastDecreaseDateTime);
            return this;
        }

        public final void setLastDecreaseDateTime(Date lastDecreaseDateTime) {
            this.lastDecreaseDateTime = StandardMemberCopier.copy((Date)lastDecreaseDateTime);
        }

        public final Long getNumberOfDecreasesToday() {
            return this.numberOfDecreasesToday;
        }

        @Override
        public final Builder numberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
            return this;
        }

        public final void setNumberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
        }

        public final Long getReadCapacityUnits() {
            return this.readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        public final Long getWriteCapacityUnits() {
            return this.writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        public ProvisionedThroughputDescription build() {
            return new ProvisionedThroughputDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisionedThroughputDescription> {
        public Builder lastIncreaseDateTime(Date var1);

        public Builder lastDecreaseDateTime(Date var1);

        public Builder numberOfDecreasesToday(Long var1);

        public Builder readCapacityUnits(Long var1);

        public Builder writeCapacityUnits(Long var1);
    }
}

