/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetItemResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetItemResponse> {
    private final Map<String, AttributeValue> item;
    private final ConsumedCapacity consumedCapacity;

    private GetItemResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public Map<String, AttributeValue> item() {
        return this.item;
    }

    public ConsumedCapacity consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.item() == null ? 0 : this.item().hashCode());
        hashCode = 31 * hashCode + (this.consumedCapacity() == null ? 0 : this.consumedCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetItemResponse)) {
            return false;
        }
        GetItemResponse other = (GetItemResponse)((Object)obj);
        if (other.item() == null ^ this.item() == null) {
            return false;
        }
        if (other.item() != null && !other.item().equals(this.item())) {
            return false;
        }
        if (other.consumedCapacity() == null ^ this.consumedCapacity() == null) {
            return false;
        }
        return other.consumedCapacity() == null || other.consumedCapacity().equals(this.consumedCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.item() != null) {
            sb.append("Item: ").append(this.item()).append(",");
        }
        if (this.consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(this.consumedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> item;
        private ConsumedCapacity consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(GetItemResponse model) {
            this.setItem(model.item);
            this.setConsumedCapacity(model.consumedCapacity);
        }

        public final Map<String, AttributeValue> getItem() {
            return this.item;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = AttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue> item) {
            this.item = AttributeMapCopier.copy(item);
        }

        public final ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
        }

        public GetItemResponse build() {
            return new GetItemResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetItemResponse> {
        public Builder item(Map<String, AttributeValue> var1);

        public Builder consumedCapacity(ConsumedCapacity var1);
    }
}

