/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.transform.DeleteRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, DeleteRequest> {
    private final Map<String, AttributeValue> key;

    private DeleteRequest(BuilderImpl builder) {
        this.key = builder.key;
    }

    public Map<String, AttributeValue> key() {
        return this.key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRequest)) {
            return false;
        }
        DeleteRequest other = (DeleteRequest)obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        return other.key() == null || other.key().equals(this.key());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeleteRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> key;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRequest model) {
            this.setKey(model.key);
        }

        public final Map<String, AttributeValue> getKey() {
            return this.key;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
        }

        public DeleteRequest build() {
            return new DeleteRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteRequest> {
        public Builder key(Map<String, AttributeValue> var1);
    }
}

