/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.Collection;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.AttributeUpdate;
import software.amazon.awssdk.services.dynamodb.document.Expected;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.UpdateItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.api.UpdateItemApi;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.spec.UpdateItemSpec;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class UpdateItemImpl
implements UpdateItemApi {
    private final Table table;
    private final DynamoDBClient client;

    public UpdateItemImpl(DynamoDBClient client, Table table) {
        this.client = client;
        this.table = table;
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new UpdateItemSpec().withPrimaryKey(primaryKey).withAttributeUpdate(attributeUpdates));
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new UpdateItemSpec().withPrimaryKey(primaryKey).withExpected(expected).withAttributeUpdate(attributeUpdates));
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new UpdateItemSpec().withPrimaryKey(primaryKey).withUpdateExpression(updateExpression).withNameMap(nameMap).valueMap(valueMap));
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new UpdateItemSpec().withPrimaryKey(primaryKey).withUpdateExpression(updateExpression).withConditionExpression(conditionExpression).withNameMap(nameMap).valueMap(valueMap));
    }

    @Override
    public UpdateItemOutcome updateItem(UpdateItemSpec spec) {
        return this.doUpdateItem(spec);
    }

    private UpdateItemOutcome doUpdateItem(UpdateItemSpec spec) {
        UpdateItemRequest.Builder requestBuilder = ((UpdateItemRequest)spec.getRequest()).toBuilder();
        requestBuilder.key(InternalUtils.toAttributeValueMap(spec.getKeyComponents()));
        requestBuilder.tableName(this.table.getTableName());
        Collection<Expected> expected = spec.getExpected();
        Map<String, ExpectedAttributeValue> expectedMap = InternalUtils.toExpectedAttributeValueMap(expected);
        requestBuilder.expected(expectedMap);
        requestBuilder.attributeUpdates(InternalUtils.toAttributeValueUpdate(spec.getAttributeUpdate()));
        requestBuilder.expressionAttributeNames(spec.nameMap());
        requestBuilder.expressionAttributeValues(InternalUtils.fromSimpleMap(spec.valueMap()));
        return new UpdateItemOutcome(this.client.updateItem((UpdateItemRequest)((Object)requestBuilder.build())));
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue), attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue), expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue), updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue), updateExpression, conditionExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), updateExpression, conditionExpression, nameMap, valueMap);
    }
}

