/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.AttributeUpdate;
import software.amazon.awssdk.services.dynamodb.document.DeleteItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.Expected;
import software.amazon.awssdk.services.dynamodb.document.GetItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.Index;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.ItemCollection;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.PutItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.QueryFilter;
import software.amazon.awssdk.services.dynamodb.document.QueryOutcome;
import software.amazon.awssdk.services.dynamodb.document.RangeKeyCondition;
import software.amazon.awssdk.services.dynamodb.document.ScanFilter;
import software.amazon.awssdk.services.dynamodb.document.ScanOutcome;
import software.amazon.awssdk.services.dynamodb.document.UpdateItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.api.DeleteItemApi;
import software.amazon.awssdk.services.dynamodb.document.api.GetItemApi;
import software.amazon.awssdk.services.dynamodb.document.api.PutItemApi;
import software.amazon.awssdk.services.dynamodb.document.api.QueryApi;
import software.amazon.awssdk.services.dynamodb.document.api.ScanApi;
import software.amazon.awssdk.services.dynamodb.document.api.UpdateItemApi;
import software.amazon.awssdk.services.dynamodb.document.internal.DeleteItemImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.GetItemImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.internal.PutItemImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.QueryImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.ScanImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.UpdateItemImpl;
import software.amazon.awssdk.services.dynamodb.document.spec.DeleteItemSpec;
import software.amazon.awssdk.services.dynamodb.document.spec.GetItemSpec;
import software.amazon.awssdk.services.dynamodb.document.spec.PutItemSpec;
import software.amazon.awssdk.services.dynamodb.document.spec.QuerySpec;
import software.amazon.awssdk.services.dynamodb.document.spec.ScanSpec;
import software.amazon.awssdk.services.dynamodb.document.spec.UpdateItemSpec;
import software.amazon.awssdk.services.dynamodb.document.spec.UpdateTableSpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterParameters;

@ThreadSafe
public class Table
implements PutItemApi,
GetItemApi,
QueryApi,
ScanApi,
UpdateItemApi,
DeleteItemApi {
    private static final long SLEEP_TIME_MILLIS = 5000L;
    private final String tableName;
    private final DynamoDBClient client;
    private final PutItemImpl putItemDelegate;
    private final GetItemImpl getItemDelegate;
    private final UpdateItemImpl updateItemDelegate;
    private final DeleteItemImpl deleteItemDelegate;
    private final QueryImpl queryDelegate;
    private final ScanImpl scanDelegate;
    private volatile TableDescription tableDescription;

    public Table(DynamoDBClient client, String tableName) {
        this(client, tableName, null);
    }

    public Table(DynamoDBClient client, String tableName, TableDescription tableDescription) {
        if (client == null) {
            throw new IllegalArgumentException("client must be specified");
        }
        if (tableName == null || tableName.trim().length() == 0) {
            throw new IllegalArgumentException("table name must not be null or empty");
        }
        this.client = client;
        this.tableName = tableName;
        this.tableDescription = tableDescription;
        this.putItemDelegate = new PutItemImpl(client, this);
        this.getItemDelegate = new GetItemImpl(client, this);
        this.updateItemDelegate = new UpdateItemImpl(client, this);
        this.deleteItemDelegate = new DeleteItemImpl(client, this);
        this.queryDelegate = new QueryImpl(client, this);
        this.scanDelegate = new ScanImpl(client, this);
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableDescription getDescription() {
        return this.tableDescription;
    }

    public TableDescription describe() {
        TableDescription description;
        DescribeTableResponse result = this.client.describeTable((DescribeTableRequest)InternalUtils.applyUserAgent((AmazonWebServiceRequest)DescribeTableRequest.builder().tableName(this.tableName).build()));
        this.tableDescription = description = result.table();
        return description;
    }

    public Index getIndex(String indexName) {
        return new Index(this.client, indexName, this);
    }

    @Override
    public PutItemOutcome putItem(Item item) {
        return this.putItemDelegate.putItem(item);
    }

    @Override
    public PutItemOutcome putItem(Item item, Expected ... expected) {
        return this.putItemDelegate.putItem(item, expected);
    }

    @Override
    public PutItemOutcome putItem(Item item, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.putItemDelegate.putItem(item, conditionExpression, nameMap, valueMap);
    }

    @Override
    public PutItemOutcome putItem(PutItemSpec spec) {
        return this.putItemDelegate.putItem(spec);
    }

    @Override
    public GetItemOutcome getItemOutcome(KeyAttribute ... primaryKeyComponents) {
        return this.getItemDelegate.getItemOutcome(primaryKeyComponents);
    }

    @Override
    public GetItemOutcome getItemOutcome(PrimaryKey primaryKey) {
        return this.getItemDelegate.getItemOutcome(primaryKey);
    }

    @Override
    public GetItemOutcome getItemOutcome(PrimaryKey primaryKey, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItemOutcome(primaryKey, projectionExpression, nameMap);
    }

    @Override
    public GetItemOutcome getItemOutcome(GetItemSpec params) {
        return this.getItemDelegate.getItemOutcome(params);
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(primaryKey, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(primaryKey, expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(primaryKey, updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(primaryKey, updateExpression, conditionExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(UpdateItemSpec updateItemSpec) {
        return this.updateItemDelegate.updateItem(updateItemSpec);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey) {
        return this.queryDelegate.query(hashKey);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(QuerySpec spec) {
        return this.queryDelegate.query(spec);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanFilter ... scanFilters) {
        return this.scanDelegate.scan(scanFilters);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.scanDelegate.scan(filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.scanDelegate.scan(filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanSpec params) {
        return this.scanDelegate.scan(params);
    }

    @Override
    public DeleteItemOutcome deleteItem(KeyAttribute ... primaryKeyComponents) {
        return this.deleteItemDelegate.deleteItem(primaryKeyComponents);
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey) {
        return this.deleteItemDelegate.deleteItem(primaryKey);
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey, Expected ... expected) {
        return this.deleteItemDelegate.deleteItem(primaryKey, expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItemDelegate.deleteItem(primaryKey, conditionExpression, nameMap, valueMap);
    }

    @Override
    public DeleteItemOutcome deleteItem(DeleteItemSpec spec) {
        return this.deleteItemDelegate.deleteItem(spec);
    }

    public TableDescription updateTable(UpdateTableSpec spec) {
        TableDescription description;
        UpdateTableRequest.Builder reqBuilder = ((UpdateTableRequest)((Object)spec.getRequest())).toBuilder();
        reqBuilder.tableName(this.getTableName());
        UpdateTableRequest updated = (UpdateTableRequest)((Object)reqBuilder.build());
        UpdateTableResponse result = this.client.updateTable(updated);
        this.tableDescription = description = result.tableDescription();
        return description;
    }

    public Index createGsi(CreateGlobalSecondaryIndexAction create, AttributeDefinition hashKeyDefinition) {
        return this.doCreateGsi(create, hashKeyDefinition);
    }

    public Index createGsi(CreateGlobalSecondaryIndexAction create, AttributeDefinition hashKeyDefinition, AttributeDefinition rangeKeyDefinition) {
        return this.doCreateGsi(create, hashKeyDefinition, rangeKeyDefinition);
    }

    private Index doCreateGsi(CreateGlobalSecondaryIndexAction create, AttributeDefinition ... keyDefinitions) {
        UpdateTableSpec spec = new UpdateTableSpec().withAttributeDefinitions(keyDefinitions).withGlobalSecondaryIndexUpdates((GlobalSecondaryIndexUpdate)GlobalSecondaryIndexUpdate.builder().create(create).build());
        this.updateTable(spec);
        return this.getIndex(create.indexName());
    }

    public TableDescription updateTable(ProvisionedThroughput provisionedThroughput) {
        return this.updateTable(new UpdateTableSpec().withProvisionedThroughput(provisionedThroughput));
    }

    public TableDescription waitForActive() throws InterruptedException {
        Waiter<DescribeTableRequest> waiter = this.client.waiters().tableExists();
        try {
            waiter.run(new WaiterParameters((AmazonWebServiceRequest)DescribeTableRequest.builder().tableName(this.tableName).build()).withPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(25), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))));
            return this.describe();
        }
        catch (Exception exception) {
            this.describe();
            throw new IllegalArgumentException("Table " + this.tableName + " did not transition into ACTIVE state.", exception);
        }
    }

    public void waitForDelete() throws InterruptedException {
        Waiter<DescribeTableRequest> waiter = this.client.waiters().tableNotExists();
        try {
            waiter.run(new WaiterParameters((AmazonWebServiceRequest)DescribeTableRequest.builder().tableName(this.tableName).build()).withPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(25), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Table " + this.tableName + " is not deleted.", exception);
        }
    }

    @Deprecated
    public TableDescription waitForActiveOrDelete() throws InterruptedException {
        try {
            while (true) {
                TableDescription desc;
                String status;
                if (TableStatus.fromValue(status = (desc = this.describe()).tableStatus()) == TableStatus.ACTIVE) {
                    return desc;
                }
                Thread.sleep(5000L);
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    @Deprecated
    public TableDescription waitForAllActiveOrDelete() throws InterruptedException {
        try {
            block2: while (true) {
                TableDescription desc;
                String status;
                if (TableStatus.fromValue(status = (desc = this.describe()).tableStatus()) == TableStatus.ACTIVE) {
                    List<GlobalSecondaryIndexDescription> descriptions = desc.globalSecondaryIndexes();
                    if (descriptions != null) {
                        for (GlobalSecondaryIndexDescription d : descriptions) {
                            status = d.indexStatus();
                            if (IndexStatus.fromValue(status) == IndexStatus.ACTIVE) continue;
                            Thread.sleep(5000L);
                            continue block2;
                        }
                    }
                    return desc;
                }
                Thread.sleep(5000L);
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    public DeleteTableResponse delete() {
        return this.client.deleteTable((DeleteTableRequest)((Object)DeleteTableRequest.builder().tableName(this.tableName).build()));
    }

    @Override
    public Item getItem(KeyAttribute ... primaryKeyComponents) {
        return this.getItemDelegate.getItem(primaryKeyComponents);
    }

    @Override
    public Item getItem(PrimaryKey primaryKey) {
        return this.getItemDelegate.getItem(primaryKey);
    }

    @Override
    public Item getItem(PrimaryKey primaryKey, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItem(primaryKey, projectionExpression, nameMap);
    }

    @Override
    public Item getItem(GetItemSpec spec) {
        return this.getItemDelegate.getItem(spec);
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue) {
        return this.getItemDelegate.getItemOutcome(hashKeyName, hashKeyValue);
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.getItemDelegate.getItemOutcome(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue) {
        return this.getItemDelegate.getItem(hashKeyName, hashKeyValue);
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.getItemDelegate.getItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, updateExpression, conditionExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, updateExpression, conditionExpression, nameMap, valueMap);
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItemOutcome(hashKeyName, hashKeyValue, projectionExpression, nameMap);
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItemOutcome(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, projectionExpression, nameMap);
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItem(hashKeyName, hashKeyValue, projectionExpression, nameMap);
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, projectionExpression, nameMap);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, Expected ... expected) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, Expected ... expected) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, conditionExpression, nameMap, valueMap);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, conditionExpression, nameMap, valueMap);
    }

    public String toString() {
        return "{" + this.tableName + ": " + this.tableDescription + "}";
    }
}

