/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.marshallers;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class MapToMapMarshaller
implements ArgumentMarshaller.MapAttributeMarshaller {
    private static final MapToMapMarshaller INSTANCE = new MapToMapMarshaller();
    private final ArgumentMarshaller memberMarshaller;

    private MapToMapMarshaller() {
        this.memberMarshaller = null;
    }

    public MapToMapMarshaller(ArgumentMarshaller memberMarshaller) {
        if (memberMarshaller == null) {
            throw new NullPointerException("memberMarshaller");
        }
        this.memberMarshaller = memberMarshaller;
    }

    public static MapToMapMarshaller instance() {
        return INSTANCE;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        if (this.memberMarshaller == null) {
            throw new IllegalStateException("No member marshaller configured!");
        }
        Map map = (Map)obj;
        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
        for (Map.Entry entry : map.entrySet()) {
            AttributeValue value = entry.getValue() == null ? (AttributeValue)AttributeValue.builder().nul(true).build() : this.memberMarshaller.marshall(entry.getValue());
            values.put((String)entry.getKey(), value);
        }
        AttributeValue result = (AttributeValue)AttributeValue.builder().m(values).build();
        return result;
    }

    public ArgumentMarshaller memberMarshaller() {
        return this.memberMarshaller;
    }
}

